<?php
require_once __DIR__ . '/config/config.php';
$pageTitle = 'تست ساده';
include __DIR__ . '/includes/header.php';
?>

<style>
body {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
}

.test-box {
    background: white;
    border-radius: 20px;
    padding: 40px;
    max-width: 600px;
    width: 100%;
    box-shadow: 0 10px 40px rgba(0,0,0,0.2);
}

h1 {
    color: #667eea;
    text-align: center;
    margin-bottom: 30px;
    font-size: 28px;
}

.status {
    padding: 20px;
    border-radius: 12px;
    margin: 15px 0;
    font-size: 18px;
    font-weight: 600;
    text-align: center;
}

.success {
    background: #d4edda;
    color: #155724;
}

.error {
    background: #f8d7da;
    color: #721c24;
}

.info {
    background: #d1ecf1;
    color: #0c5460;
    font-size: 14px;
    line-height: 1.6;
}

.links {
    display: flex;
    gap: 10px;
    margin: 20px 0;
    flex-wrap: wrap;
}

.btn {
    flex: 1;
    min-width: 150px;
    padding: 15px 20px;
    background: #667eea;
    color: white;
    border: none;
    border-radius: 10px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    text-decoration: none;
    display: inline-block;
    text-align: center;
    transition: all 0.3s;
}

.btn:hover {
    background: #5568d3;
    transform: translateY(-2px);
}

.btn-danger {
    background: #dc3545;
}

.btn-danger:hover {
    background: #c82333;
}
</style>

<div class="test-box">
    <h1>🔐 تست احراز هویت</h1>
    
    <?php if (isLoggedIn()): ?>
        <div class="status success">
            ✅ شما لاگین هستید!
        </div>
        <div class="info">
            <strong>User ID:</strong> <?php echo $_SESSION['user_id']; ?><br>
            <strong>موبایل:</strong> <?php echo $_SESSION['mobile'] ?? 'N/A'; ?><br>
            <?php if (isset($_COOKIE['auth_token'])): ?>
                <strong>Cookie:</strong> ✅ موجود است<br>
            <?php endif; ?>
            <?php if (isset($_GET['auth_token'])): ?>
                <strong>URL Token:</strong> ✅ دریافت شد<br>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <div class="status error">
            ❌ شما لاگین نیستید
        </div>
    <?php endif; ?>
    
    <div class="info">
        <strong>نکته:</strong> این صفحه برای تست سیستم احراز هویت است. 
        وقتی روی لینک‌ها کلیک می‌کنی، Token خودکار به URL اضافه میشه (برای WebView).
    </div>
    
    <div class="links">
        <a href="/dashboard.php" class="btn">🏠 داشبورد</a>
        <a href="/my-esims.php" class="btn">📱 eSIM ها</a>
    </div>
    
    <div class="links">
        <a href="/test-simple.php" class="btn">🔄 Reload</a>
        <a href="/login.php" class="btn">🔐 لاگین</a>
        <a href="/logout.php" class="btn btn-danger">🚪 خروج</a>
    </div>
</div>

<script>
    // نمایش اطلاعات در console
    console.log('📊 وضعیت:');
    console.log('localStorage token:', localStorage.getItem('auth_token') ? 'موجود' : 'ندارد');
    console.log('Cookie:', document.cookie.includes('auth_token') ? 'موجود' : 'ندارد');
    console.log('URL:', window.location.href);
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>

