<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';

requireLogin();

$pageTitle = 'Debug - eSIM های من';

// Get paid orders (active eSIMs)
$esims = getUserOrders($_SESSION['user_id'], 'paid');

include __DIR__ . '/includes/header.php';
?>

<div class="container">
    <div class="page-header">
        <h1>
            <i class="fas fa-bug"></i>
            Debug - eSIM های من
        </h1>
    </div>

    <div style="background: white; padding: 2rem; border-radius: 12px; margin-bottom: 2rem;">
        <h2>اطلاعات Session:</h2>
        <pre style="background: #f5f5f5; padding: 1rem; border-radius: 8px; overflow: auto;">
<?php print_r($_SESSION); ?>
        </pre>
    </div>

    <div style="background: white; padding: 2rem; border-radius: 12px; margin-bottom: 2rem;">
        <h2>تعداد eSIM ها: <?php echo count($esims); ?></h2>
    </div>

    <?php if (!empty($esims)): ?>
    <div style="background: white; padding: 2rem; border-radius: 12px;">
        <h2>اطلاعات eSIM ها:</h2>
        <?php foreach ($esims as $index => $esim): ?>
        <div style="background: #f5f5f5; padding: 1.5rem; border-radius: 8px; margin-bottom: 1.5rem; border: 2px solid #667eea;">
            <h3>eSIM #<?php echo ($index + 1); ?> - سفارش #<?php echo $esim['id']; ?></h3>
            <table style="width: 100%; border-collapse: collapse;">
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold; width: 200px;">ID:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['id'] ?? 'NULL'; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">Package Name:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['package_name'] ?? 'NULL'; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">Package Code:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['package_code'] ?? 'NULL'; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">Country Code:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['country_code'] ?? 'NULL'; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">Country Name:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['country_name'] ?? 'NULL'; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">Data Amount:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['data_amount'] ?? 'NULL'; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">Validity Days:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['validity_days'] ?? 'NULL'; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">Status:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['status'] ?? 'NULL'; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">eSIM ID:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['esim_id'] ?? 'NULL'; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">ICCID:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['iccid'] ?? 'NULL'; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">QR Code:</td>
                    <td style="padding: 0.5rem;">
                        <?php if (!empty($esim['qr_code'])): ?>
                            <a href="<?php echo htmlspecialchars($esim['qr_code']); ?>" target="_blank" style="color: #667eea;">
                                <?php echo substr($esim['qr_code'], 0, 50); ?>...
                            </a>
                        <?php else: ?>
                            NULL
                        <?php endif; ?>
                    </td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">Activation Code:</td>
                    <td style="padding: 0.5rem; word-break: break-all;">
                        <?php echo $esim['activation_code'] ?? 'NULL'; ?>
                    </td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">eSIM Status:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['esim_status'] ?? 'NULL'; ?></td>
                </tr>
                <tr style="border-bottom: 1px solid #ddd;">
                    <td style="padding: 0.5rem; font-weight: bold;">Created At:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['created_at'] ?? 'NULL'; ?></td>
                </tr>
                <tr>
                    <td style="padding: 0.5rem; font-weight: bold;">Updated At:</td>
                    <td style="padding: 0.5rem;"><?php echo $esim['updated_at'] ?? 'NULL'; ?></td>
                </tr>
            </table>

            <?php if (!empty($esim['qr_code'])): ?>
            <div style="margin-top: 1rem; text-align: center;">
                <h4>QR Code Preview:</h4>
                <img src="<?php echo htmlspecialchars($esim['qr_code']); ?>" 
                     alt="QR Code" 
                     style="max-width: 200px; border: 2px solid #667eea; border-radius: 8px; padding: 10px; background: white;">
            </div>
            <?php endif; ?>
        </div>
        <?php endforeach; ?>
    </div>
    <?php else: ?>
    <div style="background: #fff3cd; padding: 2rem; border-radius: 12px; text-align: center;">
        <h2 style="color: #856404;">⚠️ هیچ eSIM پرداخت شده‌ای یافت نشد</h2>
        <p style="color: #856404;">
            لطفاً یک سفارش با وضعیت "paid" در دیتابیس ایجاد کنید.
        </p>
        <a href="/dashboard.php" class="btn btn-primary" style="margin-top: 1rem;">
            بازگشت به داشبورد
        </a>
    </div>
    <?php endif; ?>

    <div style="background: #d1ecf1; padding: 2rem; border-radius: 12px; margin-top: 2rem;">
        <h3 style="color: #0c5460;">💡 راهنما:</h3>
        <ul style="color: #0c5460;">
            <li>اگر هیچ eSIM نمایش داده نمی‌شود، بررسی کنید که سفارشی با status="paid" در دیتابیس وجود دارد</li>
            <li>اگر QR Code یا Activation Code NULL است، یعنی eSIM هنوز از API دریافت نشده</li>
            <li>برای تست، می‌توانید یک سفارش جدید ایجاد کنید و پرداخت را کامل کنید</li>
        </ul>
    </div>

    <div style="text-align: center; margin-top: 2rem;">
        <a href="/my-esims.php" class="btn btn-primary">
            <i class="fas fa-arrow-left"></i>
            بازگشت به صفحه اصلی My eSIMs
        </a>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>

