<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>بررسی جدول OTP</h2>";

try {
    require_once __DIR__ . '/config/database.php';
    
    $conn = getDBConnection();
    
    // بررسی وجود جدول
    $result = $conn->query("SHOW TABLES LIKE 'otp_codes'");
    
    if ($result->num_rows > 0) {
        echo "✅ جدول otp_codes وجود دارد<br><br>";
        
        // نمایش ساختار جدول
        echo "<strong>ساختار جدول:</strong><br>";
        $structure = $conn->query("DESCRIBE otp_codes");
        echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
        echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
        while ($row = $structure->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . $row['Field'] . "</td>";
            echo "<td>" . $row['Type'] . "</td>";
            echo "<td>" . $row['Null'] . "</td>";
            echo "<td>" . $row['Key'] . "</td>";
            echo "<td>" . $row['Default'] . "</td>";
            echo "</tr>";
        }
        echo "</table><br>";
        
        // تعداد رکوردها
        $count = $conn->query("SELECT COUNT(*) as total FROM otp_codes")->fetch_assoc();
        echo "تعداد رکوردها: " . $count['total'] . "<br>";
        
    } else {
        echo "❌ جدول otp_codes وجود ندارد!<br><br>";
        echo "<strong>برای ایجاد جدول، این کد SQL را اجرا کنید:</strong><br>";
        echo "<textarea rows='15' cols='80' style='font-family: monospace;'>";
        echo "CREATE TABLE IF NOT EXISTS otp_codes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mobile VARCHAR(20) NOT NULL,
    code VARCHAR(6) NOT NULL,
    type ENUM('login', 'register') DEFAULT 'login',
    is_used TINYINT(1) DEFAULT 0,
    expires_at TIMESTAMP NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_mobile (mobile),
    INDEX idx_code (code),
    INDEX idx_expires (expires_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        echo "</textarea><br><br>";
        
        echo "<form method='POST'>";
        echo "<button type='submit' name='create_table' style='padding: 10px 20px; background: #28a745; color: white; border: none; cursor: pointer;'>ایجاد جدول</button>";
        echo "</form>";
    }
    
    // اگر دکمه ایجاد جدول زده شده
    if (isset($_POST['create_table'])) {
        echo "<hr><h3>در حال ایجاد جدول...</h3>";
        
        $sql = "CREATE TABLE IF NOT EXISTS otp_codes (
            id INT AUTO_INCREMENT PRIMARY KEY,
            mobile VARCHAR(20) NOT NULL,
            code VARCHAR(6) NOT NULL,
            type ENUM('login', 'register') DEFAULT 'login',
            is_used TINYINT(1) DEFAULT 0,
            expires_at TIMESTAMP NOT NULL,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            INDEX idx_mobile (mobile),
            INDEX idx_code (code),
            INDEX idx_expires (expires_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
        
        if ($conn->query($sql)) {
            echo "✅ جدول با موفقیت ایجاد شد!<br>";
            echo "<a href='check-otp-table.php'>بازخوانی صفحه</a>";
        } else {
            echo "❌ خطا در ایجاد جدول: " . $conn->error;
        }
    }
    
    $conn->close();
    
} catch (Exception $e) {
    echo "❌ خطا: " . $e->getMessage();
}
?>

