<?php
require_once __DIR__ . '/config/config.php';

$noAuthRedirect = true; // Home page doesn't require login
$pageTitle = 'انتخاب کشور';

// Load static list of countries (no API call needed here)
$countries = require __DIR__ . '/data/countries.php';

include __DIR__ . '/includes/header.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');

* {
    box-sizing: border-box;
}

html, body {
    overflow-x: hidden;
    max-width: 100%;
}

body, h1, h2, h3, h4, h5, h6, p, span, div, a, button, input, textarea, select, label {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
}

.fas, .far, .fab, .fa {
    font-family: "Font Awesome 6 Free", "Font Awesome 6 Brands" !important;
}

.hero-section {
    background: linear-gradient(135deg, #CB1919 0%, #FF2929 100%);
    padding: 30px 20px;
    text-align: center;
    color: white;
    margin-bottom: 30px;
    width: 100%;
    overflow: hidden;
}

.hero-section .container {
    max-width: 100%;
    width: 100%;
    padding: 0 15px;
    margin: 0 auto;
}

.container {
    max-width: 1200px;
    width: 100%;
    margin: 0 auto;
    padding: 0 20px;
}

.hero-section h1 {
    font-size: 24px;
    margin-bottom: 8px;
    font-weight: 700;
    text-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
    word-wrap: break-word;
    overflow-wrap: break-word;
    line-height: 1.4;
}

.hero-title-short {
    display: none;
}

.hero-title-full {
    display: inline;
}

.hero-section p {
    font-size: 14px;
    opacity: 0.9;
    word-wrap: break-word;
    overflow-wrap: break-word;
}

.search-box {
    background: white;
    padding: 15px 20px;
    border-radius: 50px;
    margin-bottom: 40px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
    display: flex;
    align-items: center;
    gap: 15px;
    max-width: 600px;
    margin-left: auto;
    margin-right: auto;
}

.search-box i {
    color: #FF2929;
    font-size: 20px;
}

.search-box input {
    flex: 1;
    border: none;
    outline: none;
    font-size: 16px;
    padding: 5px;
}

.countries-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 50px;
}

.country-card {
    background: white;
    border-radius: 12px;
    padding: 20px;
    text-align: center;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
    transition: all 0.3s;
    text-decoration: none;
    display: block;
}

.country-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 25px rgba(0, 0, 0, 0.15);
}

.country-flag {
    margin-bottom: 15px;
}

.country-flag img {
    width: 100%;
    max-width: 120px;
    height: 80px;
    object-fit: cover;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}

.country-name {
    font-size: 16px;
    font-weight: bold;
    color: #333;
    margin-bottom: 5px;
}

.country-code {
    font-size: 12px;
    color: #999;
    background: #f0f0f0;
    padding: 3px 10px;
    border-radius: 12px;
    display: inline-block;
}

@media (max-width: 768px) {
    .hero-section {
        padding: 20px 10px;
        margin-bottom: 20px;
    }
    
    .hero-section .container {
        padding: 0 10px;
    }
    
    .hero-section h1 {
        font-size: 18px;
        margin-bottom: 8px;
        line-height: 1.6;
        padding: 0 5px;
    }
    
    .hero-title-full {
        display: none;
    }
    
    .hero-title-short {
        display: inline;
    }
    
    .hero-section p {
        font-size: 12px;
        line-height: 1.5;
        padding: 0 5px;
    }
    
    .search-box {
        padding: 12px 15px;
        margin-bottom: 25px;
        margin-left: 15px;
        margin-right: 15px;
    }
    
    .search-box input {
        font-size: 14px;
    }
    
    .countries-grid {
        grid-template-columns: repeat(auto-fill, minmax(140px, 1fr));
        gap: 12px;
        padding: 0 10px;
    }
    
    .country-card {
        padding: 15px 10px;
    }
    
    .country-flag img {
        max-width: 100px;
        height: 65px;
    }
    
    .country-name {
        font-size: 14px;
    }
}

@media (max-width: 480px) {
    .hero-section {
        padding: 15px 8px;
    }
    
    .hero-section h1 {
        font-size: 16px;
        line-height: 1.8;
    }
    
    .hero-section p {
        font-size: 11px;
    }
    
    .search-box {
        margin-left: 10px;
        margin-right: 10px;
        padding: 10px 12px;
    }
    
    .countries-grid {
        grid-template-columns: repeat(2, 1fr);
        gap: 10px;
        padding: 0 8px;
    }
    
    .country-card {
        padding: 12px 8px;
    }
}
</style>

<div class="hero-section">
    <div class="container">
        <h1>
            <span class="hero-title-full">اولesim - خرید eSIM برای سفرهای بین‌المللی</span>
            <span class="hero-title-short">فروشگاه eSIM بین‌المللی</span>
        </h1>
        <p>بهترین بسته‌های اینترنت اول‌ esim برای بیش از <?php echo count($countries); ?> کشور جهان</p>
    </div>
</div>

<div class="container">
    <div class="search-box">
        <i class="fas fa-search"></i>
        <input type="text" id="countrySearch" placeholder="جستجوی کشور...">
    </div>

    <div class="countries-grid" id="countriesGrid">
        <?php foreach ($countries as $country): ?>
        <a href="/country.php?code=<?php echo htmlspecialchars($country['iso']); ?>" 
           class="country-card" 
           data-name="<?php echo htmlspecialchars(strtolower($country['name'] . ' ' . $country['name_fa'])); ?>">
            <div class="country-flag">
                <img src="https://flagcdn.com/w160/<?php echo strtolower($country['iso']); ?>.png" 
                     alt="<?php echo htmlspecialchars($country['name']); ?>"
                     onerror="this.src='https://via.placeholder.com/120x80?text=<?php echo htmlspecialchars($country['iso']); ?>'">
            </div>
            <div class="country-name">
                <?php echo htmlspecialchars($country['name_fa']); ?>
            </div>
            <div class="country-code">
                <?php echo htmlspecialchars($country['iso']); ?>
            </div>
        </a>
        <?php endforeach; ?>
    </div>
</div>

<script>
// Search functionality
document.getElementById('countrySearch').addEventListener('input', function(e) {
    const searchTerm = e.target.value.toLowerCase();
    const countryCards = document.querySelectorAll('.country-card');
    
    countryCards.forEach(card => {
        const countryName = card.dataset.name;
        
        if (countryName.includes(searchTerm)) {
            card.style.display = 'block';
        } else {
            card.style.display = 'none';
        }
    });
});
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
