<?php
/**
 * صفحه مدیریت اعلان‌های مصرف
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../api/esim-api.php';
require_once __DIR__ . '/../api/sms-api.php';

requireAdmin();

$success = '';
$error = '';
$threshold = 10; // درصد پیش‌فرض

// اجرای دستی چک مصرف
if (isset($_POST['run_check'])) {
    $threshold = intval($_POST['threshold'] ?? 10);
    
    $conn = getDBConnection();
    $query = "SELECT o.*, u.mobile 
              FROM orders o 
              LEFT JOIN users u ON o.user_id = u.id 
              WHERE o.status = 'paid' 
              AND o.iccid IS NOT NULL 
              AND o.iccid != ''
              ORDER BY o.created_at DESC";
    
    $result = $conn->query($query);
    $esims = [];
    while ($row = $result->fetch_assoc()) {
        $esims[] = $row;
    }
    $conn->close();
    
    $api = new eSIMAPI();
    $sms = new SmsAPI();
    $alertsSent = 0;
    $checked = 0;
    
    foreach ($esims as $esim) {
        try {
            $apiResponse = $api->queryProfile($esim['iccid']);
            
            if (!$apiResponse || !isset($apiResponse['obj']['esimList'][0])) {
                continue;
            }
            
            $esimData = $apiResponse['obj']['esimList'][0];
            $totalVolume = $esimData['totalVolume'] ?? 0;
            $usedVolume = $esimData['orderUsage'] ?? 0;
            $esimStatus = $esimData['esimStatus'] ?? '';
            
            if (!in_array($esimStatus, ['ACTIVE', 'IN_USE', 'ACTIVATED']) || $totalVolume <= 0) {
                continue;
            }
            
            $checked++;
            $remainingPercent = round((($totalVolume - $usedVolume) / $totalVolume) * 100, 1);
            
            // چک کردن اعلان قبلی
            $alreadySent = isset($esim['usage_alert_sent']) && $esim['usage_alert_sent'] == 1;
            
            if ($remainingPercent <= $threshold && !$alreadySent) {
                // ارسال SMS
                $message = "سلام از اولeSIM\n";
                $message .= "از بسته eSIM شما فقط {$remainingPercent}% باقی مانده.\n";
                $message .= "برای افزایش حجم به پنل کاربری مراجعه کنید.";
                
                $smsResult = $sms->sendSMS($esim['mobile'], $message);
                
                if ($smsResult['success']) {
                    // علامت‌گذاری
                    $conn = getDBConnection();
                    $stmt = $conn->prepare("UPDATE orders SET usage_alert_sent = 1, usage_alert_time = NOW() WHERE id = ?");
                    $stmt->bind_param("i", $esim['id']);
                    $stmt->execute();
                    $stmt->close();
                    $conn->close();
                    
                    $alertsSent++;
                }
            }
            
            usleep(100000); // 0.1 ثانیه تاخیر
            
        } catch (Exception $e) {
            // ادامه به بعدی
        }
    }
    
    $success = "چک شد: $checked eSIM | اعلان ارسال شده: $alertsSent";
}

// ریست کردن اعلان‌ها
if (isset($_POST['reset_alerts'])) {
    $conn = getDBConnection();
    $conn->query("UPDATE orders SET usage_alert_sent = 0, usage_alert_time = NULL");
    $conn->close();
    $success = "همه اعلان‌ها ریست شدند";
}

// گرفتن آمار
$conn = getDBConnection();
$stats = [];

// تعداد کل eSIM ها
$result = $conn->query("SELECT COUNT(*) as total FROM orders WHERE status = 'paid' AND iccid IS NOT NULL");
$stats['total'] = $result->fetch_assoc()['total'];

// تعداد اعلان‌های ارسال شده
$result = $conn->query("SELECT COUNT(*) as sent FROM orders WHERE usage_alert_sent = 1");
$stats['alerts_sent'] = $result->fetch_assoc()['sent'];

// لیست اعلان‌های اخیر
$result = $conn->query("SELECT o.*, u.mobile 
                        FROM orders o 
                        LEFT JOIN users u ON o.user_id = u.id 
                        WHERE o.usage_alert_sent = 1 
                        ORDER BY o.usage_alert_time DESC 
                        LIMIT 20");
$recentAlerts = [];
while ($row = $result->fetch_assoc()) {
    $recentAlerts[] = $row;
}
$conn->close();

include __DIR__ . '/../includes/header.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700&display=swap');

body, * {
    font-family: 'Vazirmatn', Tahoma, sans-serif !important;
}

.admin-container {
    display: flex;
    min-height: calc(100vh - 100px);
}

.admin-sidebar {
    width: 250px;
    background: white;
    box-shadow: 2px 0 10px rgba(0,0,0,0.1);
}

.sidebar-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 20px;
    text-align: center;
}

.sidebar-header i {
    font-size: 32px;
    margin-bottom: 10px;
}

.sidebar-menu {
    padding: 20px 0;
}

.sidebar-menu a {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 15px 20px;
    color: #666;
    text-decoration: none;
    transition: all 0.3s;
}

.sidebar-menu a:hover {
    background: #f5f5f5;
    color: #667eea;
}

.sidebar-menu a.active {
    background: #667eea;
    color: white;
}

.admin-content {
    flex: 1;
    padding: 30px;
    background: #f5f7fa;
}

.page-header h1 {
    color: #333;
    margin-bottom: 20px;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}

.stat-card {
    background: white;
    border-radius: 15px;
    padding: 25px;
    text-align: center;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
}

.stat-card i {
    font-size: 40px;
    margin-bottom: 15px;
}

.stat-card .value {
    font-size: 32px;
    font-weight: 700;
    color: #333;
}

.stat-card .label {
    color: #666;
    margin-top: 5px;
}

.section {
    background: white;
    border-radius: 15px;
    padding: 25px;
    margin-bottom: 20px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.08);
}

.section h2 {
    color: #333;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.form-row {
    display: flex;
    gap: 15px;
    align-items: end;
    flex-wrap: wrap;
}

.form-group {
    flex: 1;
    min-width: 150px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #333;
}

.form-group input {
    width: 100%;
    padding: 12px 15px;
    border: 2px solid #e0e0e0;
    border-radius: 10px;
    font-size: 15px;
}

.btn {
    padding: 12px 25px;
    border: none;
    border-radius: 10px;
    font-size: 15px;
    font-weight: 600;
    cursor: pointer;
    transition: transform 0.3s;
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.btn:hover {
    transform: translateY(-2px);
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-warning {
    background: #f59e0b;
    color: white;
}

.btn-danger {
    background: #dc3545;
    color: white;
}

.alert {
    padding: 15px 20px;
    border-radius: 10px;
    margin-bottom: 20px;
}

.alert-success {
    background: #d4edda;
    border: 1px solid #c3e6cb;
    color: #155724;
}

.alert-error {
    background: #f8d7da;
    border: 1px solid #f5c6cb;
    color: #721c24;
}

.data-table {
    width: 100%;
    border-collapse: collapse;
}

.data-table th {
    background: #f8f9fa;
    padding: 12px;
    text-align: right;
    font-weight: 600;
    color: #666;
}

.data-table td {
    padding: 12px;
    border-bottom: 1px solid #f0f0f0;
}

.data-table tr:hover {
    background: #f8f9fa;
}

.badge {
    display: inline-block;
    padding: 5px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.badge-success {
    background: #d4edda;
    color: #155724;
}

.info-box {
    background: #e8f4fd;
    border: 1px solid #b8daff;
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 20px;
    color: #004085;
}

.cron-code {
    background: #263238;
    color: #80CBC4;
    padding: 15px;
    border-radius: 8px;
    direction: ltr;
    text-align: left;
    font-family: monospace;
    font-size: 13px;
    margin-top: 10px;
}

@media (max-width: 768px) {
    .admin-container {
        flex-direction: column;
    }
    
    .admin-sidebar {
        width: 100%;
    }
    
    .form-row {
        flex-direction: column;
    }
}
</style>

<div class="admin-container">
    <div class="admin-sidebar">
        <div class="sidebar-header">
            <i class="fas fa-shield-alt"></i>
            <h3>پنل مدیریت</h3>
        </div>
        <nav class="sidebar-menu">
            <a href="/admin/"><i class="fas fa-home"></i> داشبورد</a>
            <a href="/admin/users.php"><i class="fas fa-users"></i> کاربران</a>
            <a href="/admin/orders.php"><i class="fas fa-shopping-cart"></i> سفارش‌ها</a>
            <a href="/admin/esims.php"><i class="fas fa-sim-card"></i> eSIM ها</a>
            <a href="/admin/usage-alerts.php" class="active"><i class="fas fa-bell"></i> اعلان‌ها</a>
            <a href="/admin/settings.php"><i class="fas fa-cog"></i> تنظیمات</a>
            <a href="/"><i class="fas fa-arrow-left"></i> بازگشت</a>
        </nav>
    </div>

    <div class="admin-content">
        <div class="page-header">
            <h1><i class="fas fa-bell"></i> مدیریت اعلان‌های مصرف</h1>
        </div>

        <?php if ($success): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?php echo $success; ?>
        </div>
        <?php endif; ?>

        <?php if ($error): ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
        </div>
        <?php endif; ?>

        <!-- آمار -->
        <div class="stats-grid">
            <div class="stat-card">
                <i class="fas fa-sim-card" style="color:#667eea;"></i>
                <div class="value"><?php echo $stats['total']; ?></div>
                <div class="label">کل eSIM های فعال</div>
            </div>
            <div class="stat-card">
                <i class="fas fa-bell" style="color:#f59e0b;"></i>
                <div class="value"><?php echo $stats['alerts_sent']; ?></div>
                <div class="label">اعلان‌های ارسال شده</div>
            </div>
        </div>

        <!-- اجرای دستی -->
        <div class="section">
            <h2><i class="fas fa-play"></i> اجرای دستی چک مصرف</h2>
            
            <form method="POST">
                <div class="form-row">
                    <div class="form-group">
                        <label>آستانه اعلان (درصد باقیمانده):</label>
                        <input type="number" name="threshold" value="<?php echo $threshold; ?>" min="1" max="50">
                    </div>
                    <button type="submit" name="run_check" class="btn btn-primary">
                        <i class="fas fa-play"></i>
                        اجرای چک مصرف
                    </button>
                    <button type="submit" name="reset_alerts" class="btn btn-danger" 
                            onclick="return confirm('همه اعلان‌ها ریست شوند؟');">
                        <i class="fas fa-undo"></i>
                        ریست اعلان‌ها
                    </button>
                </div>
            </form>
            
            <div class="info-box" style="margin-top:20px;">
                <i class="fas fa-info-circle"></i>
                <strong>توضیح:</strong> وقتی باقیمانده حجم eSIM کمتر از آستانه تعیین شده باشد، 
                یک پیامک اعلان به کاربر ارسال می‌شود.
            </div>
        </div>

        <!-- تنظیم Cron -->
        <div class="section">
            <h2><i class="fas fa-clock"></i> تنظیم Cron Job</h2>
            
            <p>برای اجرای خودکار، یکی از دستورات زیر را به cron اضافه کنید:</p>
            
            <div class="cron-code">
# هر 6 ساعت یکبار<br>
0 */6 * * * php <?php echo __DIR__; ?>/../cron-check-usage.php<br><br>
# یا از طریق URL:<br>
0 */6 * * * curl -s "https://yoursite.com/cron-check-usage.php?key=esim_cron_2024_secret"
            </div>
        </div>

        <!-- لیست اعلان‌های اخیر -->
        <div class="section">
            <h2><i class="fas fa-history"></i> اعلان‌های اخیر</h2>
            
            <?php if (empty($recentAlerts)): ?>
            <p style="text-align:center;color:#999;padding:30px;">هنوز اعلانی ارسال نشده است</p>
            <?php else: ?>
            <table class="data-table">
                <thead>
                    <tr>
                        <th>سفارش</th>
                        <th>موبایل</th>
                        <th>بسته</th>
                        <th>زمان ارسال</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recentAlerts as $alert): ?>
                    <tr>
                        <td>#<?php echo $alert['id']; ?></td>
                        <td><?php echo htmlspecialchars($alert['mobile']); ?></td>
                        <td><?php echo htmlspecialchars($alert['package_name']); ?></td>
                        <td><?php echo $alert['usage_alert_time'] ? date('Y/m/d H:i', strtotime($alert['usage_alert_time'])) : '-'; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>

