<?php
/**
 * اضافه کردن ستون‌های گم شده به جدول orders
 * این اسکریپت فقط یک بار اجرا شود
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';

echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Add Missing Columns</title>";
echo "<style>
body { font-family: Arial, sans-serif; padding: 2rem; background: #f5f5f5; }
.success { background: #d4edda; color: #155724; padding: 1rem; border-radius: 8px; margin: 1rem 0; border: 2px solid #c3e6cb; }
.error { background: #f8d7da; color: #721c24; padding: 1rem; border-radius: 8px; margin: 1rem 0; border: 2px solid #f5c6cb; }
.info { background: #d1ecf1; color: #0c5460; padding: 1rem; border-radius: 8px; margin: 1rem 0; border: 2px solid #bee5eb; }
.warning { background: #fff3cd; color: #856404; padding: 1rem; border-radius: 8px; margin: 1rem 0; border: 2px solid #ffeaa7; }
h1 { color: #333; }
pre { background: #f8f9fa; padding: 1rem; border-radius: 4px; overflow: auto; }
</style></head><body>";

echo "<h1>🔧 اضافه کردن ستون‌های گم شده</h1>";

$conn = getDBConnection();

// لیست ستون‌های مورد نیاز
$requiredColumns = [
    'esim_status' => "VARCHAR(50) DEFAULT NULL COMMENT 'وضعیت eSIM از API'",
    'updated_at' => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'تاریخ آخرین بروزرسانی'"
];

// دریافت ستون‌های موجود
$result = $conn->query("DESCRIBE orders");
$existingColumns = [];
while ($row = $result->fetch_assoc()) {
    $existingColumns[] = $row['Field'];
}

echo "<div class='info'>";
echo "<h3>ستون‌های موجود در جدول orders:</h3>";
echo "<pre>" . implode(", ", $existingColumns) . "</pre>";
echo "</div>";

// بررسی و اضافه کردن ستون‌های گم شده
$addedColumns = [];
$skippedColumns = [];

foreach ($requiredColumns as $columnName => $columnDef) {
    if (!in_array($columnName, $existingColumns)) {
        try {
            $sql = "ALTER TABLE orders ADD COLUMN $columnName $columnDef";
            if ($conn->query($sql)) {
                $addedColumns[] = $columnName;
                echo "<div class='success'>";
                echo "<strong>✓ ستون '$columnName' با موفقیت اضافه شد</strong><br>";
                echo "<code>$sql</code>";
                echo "</div>";
            } else {
                echo "<div class='error'>";
                echo "<strong>✗ خطا در اضافه کردن ستون '$columnName':</strong><br>";
                echo $conn->error;
                echo "</div>";
            }
        } catch (Exception $e) {
            echo "<div class='error'>";
            echo "<strong>✗ خطا در اضافه کردن ستون '$columnName':</strong><br>";
            echo $e->getMessage();
            echo "</div>";
        }
    } else {
        $skippedColumns[] = $columnName;
        echo "<div class='warning'>";
        echo "<strong>⚠ ستون '$columnName' از قبل وجود دارد (رد شد)</strong>";
        echo "</div>";
    }
}

// خلاصه نتایج
echo "<hr>";
echo "<h2>📊 خلاصه نتایج:</h2>";

if (!empty($addedColumns)) {
    echo "<div class='success'>";
    echo "<h3>✓ ستون‌های اضافه شده (" . count($addedColumns) . "):</h3>";
    echo "<ul>";
    foreach ($addedColumns as $col) {
        echo "<li>$col</li>";
    }
    echo "</ul>";
    echo "</div>";
}

if (!empty($skippedColumns)) {
    echo "<div class='warning'>";
    echo "<h3>⚠ ستون‌های موجود (رد شده) (" . count($skippedColumns) . "):</h3>";
    echo "<ul>";
    foreach ($skippedColumns as $col) {
        echo "<li>$col</li>";
    }
    echo "</ul>";
    echo "</div>";
}

// نمایش ساختار نهایی جدول
echo "<hr>";
echo "<h2>📋 ساختار نهایی جدول orders:</h2>";
$result = $conn->query("DESCRIBE orders");
echo "<table style='width: 100%; border-collapse: collapse; background: white;'>";
echo "<tr style='background: #667eea; color: white;'>";
echo "<th style='padding: 10px; text-align: right; border: 1px solid #ddd;'>نام ستون</th>";
echo "<th style='padding: 10px; text-align: right; border: 1px solid #ddd;'>نوع</th>";
echo "<th style='padding: 10px; text-align: center; border: 1px solid #ddd;'>Null</th>";
echo "<th style='padding: 10px; text-align: right; border: 1px solid #ddd;'>Key</th>";
echo "<th style='padding: 10px; text-align: right; border: 1px solid #ddd;'>Default</th>";
echo "<th style='padding: 10px; text-align: right; border: 1px solid #ddd;'>Extra</th>";
echo "</tr>";

while ($row = $result->fetch_assoc()) {
    $isNew = in_array($row['Field'], $addedColumns);
    $bgColor = $isNew ? '#d4edda' : 'white';
    echo "<tr style='background: $bgColor;'>";
    echo "<td style='padding: 8px; border: 1px solid #ddd;'><strong>" . $row['Field'] . "</strong></td>";
    echo "<td style='padding: 8px; border: 1px solid #ddd;'>" . $row['Type'] . "</td>";
    echo "<td style='padding: 8px; border: 1px solid #ddd; text-align: center;'>" . $row['Null'] . "</td>";
    echo "<td style='padding: 8px; border: 1px solid #ddd;'>" . $row['Key'] . "</td>";
    echo "<td style='padding: 8px; border: 1px solid #ddd;'>" . ($row['Default'] ?? 'NULL') . "</td>";
    echo "<td style='padding: 8px; border: 1px solid #ddd;'>" . $row['Extra'] . "</td>";
    echo "</tr>";
}
echo "</table>";

$conn->close();

echo "<hr>";
echo "<div class='info'>";
echo "<h3>✅ عملیات تکمیل شد!</h3>";
echo "<p>حالا می‌توانید از صفحات زیر استفاده کنید:</p>";
echo "<ul>";
echo "<li><a href='/error-check.php'>تست کامل سیستم</a></li>";
echo "<li><a href='/check-orders.php'>بررسی سفارشات</a></li>";
echo "<li><a href='/my-esims.php'>صفحه My eSIMs</a></li>";
echo "</ul>";
echo "</div>";

echo "<div class='warning'>";
echo "<h3>⚠ نکته امنیتی:</h3>";
echo "<p><strong>این فایل را بعد از اجرا حذف کنید یا به نام دیگری تغییر دهید!</strong></p>";
echo "</div>";

echo "</body></html>";
?>

