# 🔄 راهنمای تغییر کد پترن IPPanel

## 🎯 مشکل
کد پترن در **دیتابیس** ذخیره شده است، نه در کد برنامه!

وقتی اولین بار نصب شد، کد قدیمی `v43ncjmlxcwaczv` در جدول `settings` ذخیره شد.

---

## ✅ راه‌حل (دو روش دارید)

### 🚀 روش 1: استفاده از فایل آپدیت (راحت‌تر)

1. فایل `update-pattern-code.php` را آپلود کنید
2. به این آدرس بروید:
   ```
   https://esim.matinacard.com/update-pattern-code.php
   ```
3. صفحه نشان می‌دهد که آپدیت موفق بود
4. **حتماً فایل را حذف کنید!** (برای امنیت)

---

### 🔧 روش 2: تغییر دستی از phpMyAdmin

اگر فایل کار نکرد، این query را در phpMyAdmin اجرا کنید:

```sql
UPDATE settings 
SET setting_value = 'lourive2zquwy5h' 
WHERE setting_key = 'ippanel_pattern_code';
```

---

### 🎨 روش 3: از طریق صفحه تنظیمات

1. به این آدرس بروید:
   ```
   https://esim.matinacard.com/otp-settings.php
   ```
2. در قسمت "Pattern Code" کد جدید را وارد کنید: `lourive2zquwy5h`
3. دکمه ذخیره را بزنید

---

## 🔍 بررسی که تغییر انجام شد

### روش 1: از صفحه Debug
```
https://esim.matinacard.com/debug-ippanel.php
```
باید Pattern Code جدید را نشان دهد.

### روش 2: از دیتابیس
```sql
SELECT * FROM settings WHERE setting_key = 'ippanel_pattern_code';
```
باید `lourive2zquwy5h` را نشان دهد.

---

## 📝 فایل‌های تغییر یافته

✅ `api/otp-service.php` - مقدار پیش‌فرض تغییر کرد
✅ `install-otp-db.php` - برای نصب‌های جدید
✅ `update-pattern-code.php` - **جدید** - برای آپدیت دیتابیس

---

## ⚠️ نکات مهم

1. **تغییر کد در فایل کافی نیست!** باید دیتابیس هم آپدیت شود
2. بعد از آپدیت، فایل `update-pattern-code.php` را حذف کنید
3. می‌توانید از صفحه `otp-settings.php` برای تغییرات آینده استفاده کنید
4. کد پترن باید با کدی که در پنل IPPanel ساخته‌اید مطابقت داشته باشد

---

## 🧪 تست

بعد از تغییر، یک OTP ارسال کنید و بررسی کنید که:
- ✅ پیامک ارسال می‌شود
- ✅ قالب پیامک درست است
- ✅ کد OTP صحیح است

---

## 🆘 اگر مشکل داشت

اگر هنوز کار نمی‌کند:

1. پاک کردن کش مرورگر
2. بررسی لاگ‌های سرور (error_log)
3. بررسی پنل IPPanel که پترن فعال است
4. بررسی اعتبار حساب IPPanel

---

**✨ موفق باشید!**

