# 📱 فایل‌های JSON برای اپ موبایل

این پوشه شامل فایل‌های JSON برای نمایش صفحات مختلف در اپ موبایل است.

---

## 📁 فایل‌های موجود

### 1️⃣ `my-esims.json`
- **توضیح:** صفحه لیست eSIM های کاربر (با داده)
- **محتوا:**
  - Header قرمز با عنوان "لیست eSIM ها"
  - 3 کارت نمونه eSIM (ترکیه، امارات، آلمان)
  - اطلاعات هر eSIM:
    - پرچم کشور
    - نام کشور و بسته
    - حجم داده
    - اعتبار (روز)
    - تاریخ خرید
    - ICCID
  - دکمه‌های "جزئیات" (قرمز) و "شارژ" (سبز)
  - دکمه "خرید eSIM جدید" در پایین

### 2️⃣ `my-esims-empty.json`
- **توضیح:** صفحه لیست eSIM ها (بدون داده / خالی)
- **محتوا:**
  - Header قرمز با عنوان "لیست eSIM ها"
  - پیام "هنوز eSIM ندارید!"
  - آیکون 📭
  - دکمه "خرید eSIM"

---

## 🎨 طراحی

### رنگ‌بندی:
- 🔴 **قرمز اصلی:** `#CB1919` → `#FF2929` (gradient)
- 🟢 **سبز (شارژ):** `#28a745` → `#34ce57` (gradient)
- ⚪ **پس‌زمینه:** `#f5f5f5`
- ⬜ **کارت‌ها:** سفید با shadow

### عناصر:
- **Header:** Gradient قرمز با border-radius پایین
- **کارت‌های eSIM:** 
  - Border-radius: 16px
  - Shadow: 0 3px 15px rgba(0,0,0,0.08)
  - Padding: 18px
  - Margin: 0 15px 15px 15px
- **دکمه‌ها:**
  - Gradient backgrounds
  - Border-radius: 10-15px
  - Box-shadow برای depth
  - Font-weight: 700

---

## 🔗 لینک‌ها

همه لینک‌ها به `#/nav/web-page203` اشاره می‌کنند.
برای استفاده واقعی، باید این لینک‌ها به صفحات مناسب تغییر کنند:

- **جزئیات:** `#/nav/esim-details?id={esim_id}`
- **شارژ:** `#/nav/buy-more-data?iccid={iccid}`
- **خرید eSIM جدید:** `#/nav/home` یا `#/nav/countries`

---

## 🚀 استفاده در اپ

### نمایش لیست با داده:
```json
GET /mobile-app/my-esims.json
```

### نمایش لیست خالی:
```json
GET /mobile-app/my-esims-empty.json
```

### منطق:
```javascript
if (user.esims.length > 0) {
    // نمایش my-esims.json با داده‌های واقعی کاربر
} else {
    // نمایش my-esims-empty.json
}
```

---

## 💡 نکات مهم

1. **داده‌های داینامیک:**
   - این فایل‌ها نمونه استاتیک هستند
   - برای استفاده واقعی، باید یک API endpoint ساخته شود که:
     - داده‌های eSIM کاربر از دیتابیس بخواند
     - JSON مشابه این ساختار بسازد
     - داده‌های واقعی را جایگزین نماید

2. **پرچم کشورها:**
   - از `https://flagcdn.com/w160/{country_code}.png` استفاده می‌شود
   - مثال: `tr.png` برای ترکیه، `ae.png` برای امارات

3. **Responsive:**
   - طراحی برای موبایل بهینه شده
   - تمام سایزها با pixel مشخص شده
   - از flexbox برای layout استفاده شده

4. **Font:**
   - فونت پیش‌فرض سیستم: `Vazirmatn, Tahoma, Arial, sans-serif`
   - برای اپ موبایل، مطمئن شوید فونت Vazirmatn لود می‌شود

---

## 📊 ساختار JSON

```json
[
  {
    "row_type": "wraper",
    "items": [
      {
        "row_type": "section",
        "items": [
          {
            "row_type": "content",
            "content": "HTML content here",
            "size": "full",
            "options": { ... }
          }
        ],
        "size": "full",
        "options": { ... }
      }
    ],
    "size": "full",
    "options": { ... }
  }
]
```

---

## ✅ تست

برای تست:
1. فایل JSON را در اپ موبایل باز کنید
2. چک کنید که:
   - Header قرمز نمایش داده می‌شود
   - کارت‌های eSIM درست نمایش داده می‌شوند
   - پرچم‌ها لود می‌شوند
   - دکمه‌ها قابل کلیک هستند
   - Scroll عمودی کار می‌کند
   - در سایزهای مختلف صفحه نمایش درست است

---

## 🎯 مراحل بعدی

برای استفاده در پروداکشن:

1. **ساخت API Endpoint:**
   ```php
   // mobile-app/api/my-esims.php
   GET /mobile-app/api/my-esims.php
   ```

2. **خواندن داده‌های کاربر:**
   ```php
   $esims = getUserESIMs($user_id);
   ```

3. **ساخت JSON داینامیک:**
   ```php
   foreach ($esims as $esim) {
       // ساخت section برای هر eSIM
   }
   ```

4. **Return JSON:**
   ```php
   header('Content-Type: application/json');
   echo json_encode($json_data);
   ```

---

**ساخته شده برای:** اپ موبایل اول eSIM  
**تاریخ:** نوامبر 2024  
**نسخه:** 1.0

