<?php
/**
 * نصب سیستم اعلان مصرف
 * این فایل رو یکبار اجرا کنید تا فیلدهای لازم به دیتابیس اضافه بشن
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';

echo "<!DOCTYPE html><html dir='rtl'><head><meta charset='UTF-8'><title>نصب سیستم اعلان</title>";
echo "<style>body{font-family:Tahoma;padding:30px;background:#f5f7fa;} .box{background:white;padding:20px;border-radius:10px;margin-bottom:15px;box-shadow:0 2px 10px rgba(0,0,0,0.1);} .success{color:green;} .error{color:red;} .info{color:blue;} code{background:#f0f0f0;padding:3px 8px;border-radius:5px;}</style>";
echo "</head><body>";

echo "<h1>🔧 نصب سیستم اعلان مصرف eSIM</h1>";

$conn = getDBConnection();
$changes = [];

// 1. چک و اضافه کردن usage_alert_sent
echo "<div class='box'>";
echo "<h3>1. فیلد usage_alert_sent</h3>";
$check1 = $conn->query("SHOW COLUMNS FROM orders LIKE 'usage_alert_sent'");
if ($check1 && $check1->num_rows > 0) {
    echo "<p class='info'>✅ این فیلد قبلاً وجود دارد</p>";
} else {
    $sql1 = "ALTER TABLE orders ADD COLUMN usage_alert_sent TINYINT(1) DEFAULT 0";
    if ($conn->query($sql1)) {
        echo "<p class='success'>✅ فیلد با موفقیت اضافه شد</p>";
        $changes[] = 'usage_alert_sent';
    } else {
        echo "<p class='error'>❌ خطا: " . $conn->error . "</p>";
    }
}
echo "</div>";

// 2. چک و اضافه کردن usage_alert_time
echo "<div class='box'>";
echo "<h3>2. فیلد usage_alert_time</h3>";
$check2 = $conn->query("SHOW COLUMNS FROM orders LIKE 'usage_alert_time'");
if ($check2 && $check2->num_rows > 0) {
    echo "<p class='info'>✅ این فیلد قبلاً وجود دارد</p>";
} else {
    $sql2 = "ALTER TABLE orders ADD COLUMN usage_alert_time DATETIME NULL";
    if ($conn->query($sql2)) {
        echo "<p class='success'>✅ فیلد با موفقیت اضافه شد</p>";
        $changes[] = 'usage_alert_time';
    } else {
        echo "<p class='error'>❌ خطا: " . $conn->error . "</p>";
    }
}
echo "</div>";

// 3. چک و اضافه کردن esim_tran_no
echo "<div class='box'>";
echo "<h3>3. فیلد esim_tran_no</h3>";
$check3 = $conn->query("SHOW COLUMNS FROM orders LIKE 'esim_tran_no'");
if ($check3 && $check3->num_rows > 0) {
    echo "<p class='info'>✅ این فیلد قبلاً وجود دارد</p>";
} else {
    $sql3 = "ALTER TABLE orders ADD COLUMN esim_tran_no VARCHAR(100) NULL";
    if ($conn->query($sql3)) {
        echo "<p class='success'>✅ فیلد با موفقیت اضافه شد</p>";
        $changes[] = 'esim_tran_no';
    } else {
        echo "<p class='error'>❌ خطا: " . $conn->error . "</p>";
    }
}
echo "</div>";

// نتیجه نهایی
echo "<div class='box' style='background:linear-gradient(135deg,#667eea,#764ba2);color:white;'>";
if (count($changes) > 0) {
    echo "<h3>✅ نصب با موفقیت انجام شد!</h3>";
    echo "<p>فیلدهای اضافه شده: <code style='color:#333;'>" . implode(', ', $changes) . "</code></p>";
} else {
    echo "<h3>✅ همه فیلدها قبلاً وجود داشتند</h3>";
}
echo "<p style='margin-top:15px;'>حالا می‌توانید سیستم اعلان رو تست کنید:</p>";
echo "<a href='/cron-check-usage.php?key=esim_cron_2024_secret' style='display:inline-block;background:white;color:#667eea;padding:10px 20px;border-radius:8px;text-decoration:none;font-weight:bold;margin-top:10px;'>تست اعلان مصرف</a>";
echo "</div>";

// نمایش ساختار جدول
echo "<div class='box'>";
echo "<h3>📋 ساختار فعلی جدول orders:</h3>";
$result = $conn->query("DESCRIBE orders");
if ($result) {
    echo "<table border='1' cellpadding='8' style='border-collapse:collapse;width:100%;font-size:13px;'>";
    echo "<tr style='background:#667eea;color:white;'><th>Field</th><th>Type</th><th>Null</th><th>Default</th></tr>";
    while ($row = $result->fetch_assoc()) {
        $highlight = (in_array($row['Field'], ['usage_alert_sent', 'usage_alert_time', 'esim_tran_no'])) ? "style='background:#d1fae5;'" : "";
        echo "<tr $highlight>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . ($row['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
}
echo "</div>";

$conn->close();

echo "</body></html>";
?>

