<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/api/esim-api.php';

requireLogin();

$pageTitle = 'eSIM های من';

// Get user's paid orders
$conn = getDBConnection();
$stmt = $conn->prepare("SELECT * FROM orders WHERE user_id = ? AND status = 'paid' ORDER BY created_at DESC");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$result = $stmt->get_result();
$esims = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();
$conn->close();

$api = new eSIMAPI();

include __DIR__ . '/includes/header.php';
?>

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
    background: #f5f5f5 !important;
    padding-top: 80px;
    direction: rtl;
}

/* Keep Font Awesome for icons */
.fas, .far, .fab, .fa {
    font-family: "Font Awesome 6 Free", "Font Awesome 6 Brands" !important;
}

.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 20px;
    width: 100%;
    overflow-x: hidden;
}

/* Page Header */
.page-header {
    background: linear-gradient(135deg, #CB1919 0%, #FF2929 100%);
    border-radius: 12px;
    padding: 25px 30px;
    margin-bottom: 25px;
    box-shadow: 0 3px 15px rgba(203, 25, 25, 0.2);
}

.page-header h1 {
    color: white;
    font-size: 1.8rem;
    margin: 0;
    font-weight: 700;
}

.page-header h1 i {
    margin-left: 10px;
}

/* eSIMs Section */
.esims-section {
    width: 100%;
    overflow-x: hidden;
}

/* eSIM Cards Grid */
.esims-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 20px;
    width: 100%;
}

/* eSIM Card */
.esim-card {
    background: white;
    border-radius: 16px;
    padding: 20px;
    border: 2px solid #f0f0f0;
    transition: all 0.3s ease;
    width: 100%;
    max-width: 100%;
    box-sizing: border-box;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.08);
    overflow: hidden;
}

.esim-card:hover {
    box-shadow: 0 8px 25px rgba(203, 25, 25, 0.2);
    transform: translateY(-5px);
    border-color: #FF2929;
}

.esim-header {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 15px;
    padding-bottom: 15px;
    border-bottom: 2px solid #f0f0f0;
}

.esim-flag {
    width: 60px;
    height: 45px;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 3px 10px rgba(0,0,0,0.15);
    flex-shrink: 0;
    border: 2px solid #f0f0f0;
}

.esim-flag img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
}

.esim-title {
    flex: 1;
    min-width: 0;
}

.esim-country {
    font-size: 1.2rem;
    font-weight: 700;
    color: #333;
    margin-bottom: 5px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.esim-package {
    font-size: 0.9rem;
    color: #666;
    font-weight: 500;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.esim-body {
    margin-bottom: 15px;
}

.esim-info-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 0;
    font-size: 0.95rem;
    border-bottom: 1px solid #f5f5f5;
    gap: 10px;
}

.esim-info-row:last-child {
    border-bottom: none;
}

.esim-info-label {
    color: #666;
    font-weight: 600;
    white-space: nowrap;
}

.esim-info-value {
    color: #333;
    font-weight: 700;
    text-align: left;
    word-wrap: break-word;
    overflow-wrap: break-word;
}

.esim-actions {
    display: flex;
    gap: 10px;
    margin-top: 15px;
    width: 100%;
}

.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    padding: 12px 20px;
    border-radius: 10px;
    text-decoration: none;
    font-weight: 700;
    font-size: 0.95rem;
    transition: all 0.3s ease;
    flex: 1;
    border: none;
    cursor: pointer;
    white-space: nowrap;
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
    box-sizing: border-box;
    min-width: 0;
}

.btn-primary {
    background: linear-gradient(135deg, #CB1919 0%, #FF2929 100%);
    color: white;
    box-shadow: 0 3px 10px rgba(203, 25, 25, 0.2);
}

.btn-primary:hover {
    background: linear-gradient(135deg, #FF2929 0%, #FF4444 100%);
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(203, 25, 25, 0.3);
}

.btn-success {
    background: linear-gradient(135deg, #28a745 0%, #34ce57 100%);
    color: white;
    box-shadow: 0 3px 10px rgba(40, 167, 69, 0.2);
}

.btn-success:hover {
    background: linear-gradient(135deg, #34ce57 0%, #4ade80 100%);
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(40, 167, 69, 0.3);
}

/* No eSIMs */
.no-esims {
    text-align: center;
    padding: 60px 20px;
    background: white;
    border-radius: 16px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.08);
}

.no-esims i {
    font-size: 80px;
    margin-bottom: 20px;
    color: #FF2929;
    opacity: 0.3;
}

.no-esims h3 {
    color: #333;
    margin-bottom: 15px;
    font-size: 1.5rem;
    font-weight: 700;
}

.no-esims p {
    margin-bottom: 25px;
    font-size: 1rem;
    color: #666;
}

.no-esims .btn {
    display: inline-flex;
    background: linear-gradient(135deg, #CB1919 0%, #FF2929 100%);
    color: white;
    padding: 14px 35px;
    font-size: 1rem;
}

.no-esims .btn:hover {
    background: linear-gradient(135deg, #FF2929 0%, #FF4444 100%);
    box-shadow: 0 5px 15px rgba(203, 25, 25, 0.3);
}

/* Tablet */
@media (max-width: 992px) {
    .esims-grid {
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    }
}

/* Mobile Responsive */
@media (max-width: 768px) {
    body {
        padding-top: 70px;
    }
    
    .container {
        padding: 12px;
        max-width: 100%;
        width: 100%;
        overflow-x: hidden;
    }
    
    .page-header {
        padding: 20px 18px;
        margin-bottom: 15px;
        border-radius: 12px;
    }
    
    .page-header h1 {
        font-size: 1.4rem;
    }
    
    .esims-section {
        padding: 0;
        width: 100%;
        overflow-x: hidden;
    }
    
    .esims-grid {
        grid-template-columns: 1fr;
        gap: 15px;
        width: 100%;
    }
    
    .esim-card {
        padding: 16px;
        border-radius: 12px;
        width: 100%;
        max-width: 100%;
        margin: 0;
        box-sizing: border-box;
        overflow: hidden;
    }
    
    .esim-header {
        gap: 12px;
        margin-bottom: 12px;
        padding-bottom: 12px;
        width: 100%;
    }
    
    .esim-flag {
        width: 55px;
        height: 40px;
        flex-shrink: 0;
    }
    
    .esim-title {
        flex: 1;
        min-width: 0;
        overflow: hidden;
    }
    
    .esim-country {
        font-size: 1.1rem;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .esim-package {
        font-size: 0.85rem;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .esim-body {
        width: 100%;
        overflow: hidden;
    }
    
    .esim-info-row {
        padding: 10px 0;
        font-size: 0.9rem;
        width: 100%;
        gap: 8px;
    }
    
    .esim-info-label {
        flex-shrink: 0;
    }
    
    .esim-info-value {
        text-align: left;
        word-break: break-all;
        overflow-wrap: anywhere;
    }
    
    .esim-actions {
        flex-direction: column;
        gap: 10px;
        width: 100%;
    }
    
    .btn {
        padding: 13px 16px;
        font-size: 0.9rem;
        width: 100% !important;
        max-width: 100%;
        box-sizing: border-box;
        flex: none;
    }
    
    .no-esims {
        padding: 50px 20px;
    }
    
    .no-esims i {
        font-size: 60px;
    }
    
    .no-esims h3 {
        font-size: 1.3rem;
    }
}

/* Extra small screens */
@media (max-width: 480px) {
    .container {
        padding: 10px;
        width: 100%;
    }
    
    .page-header {
        padding: 16px 14px;
        margin-bottom: 12px;
    }
    
    .page-header h1 {
        font-size: 1.2rem;
    }
    
    .esims-section {
        width: 100%;
    }
    
    .esims-grid {
        gap: 12px;
        width: 100%;
    }
    
    .esim-card {
        padding: 14px;
        width: 100%;
        max-width: 100%;
    }
    
    .esim-flag {
        width: 50px;
        height: 35px;
    }
    
    .esim-country {
        font-size: 1rem;
    }
    
    .esim-package {
        font-size: 0.8rem;
    }
    
    .esim-info-row {
        font-size: 0.85rem;
        padding: 8px 0;
    }
    
    .btn {
        padding: 12px 14px;
        font-size: 0.85rem;
        gap: 6px;
        width: 100% !important;
    }
}

/* Very small screens */
@media (max-width: 360px) {
    .container {
        padding: 8px;
        width: 100%;
    }
    
    .page-header {
        padding: 14px 12px;
    }
    
    .page-header h1 {
        font-size: 1.1rem;
    }
    
    .esim-card {
        padding: 12px;
        width: 100%;
        max-width: 100%;
    }
    
    .esim-flag {
        width: 45px;
        height: 32px;
    }
    
    .esim-country {
        font-size: 0.95rem;
    }
    
    .btn {
        padding: 11px 12px;
        font-size: 0.8rem;
        width: 100% !important;
    }
}
</style>

<div class="container">
    <!-- Page Header -->
    <div class="page-header">
        <h1><i class="fas fa-sim-card"></i> لیست eSIM ها</h1>
    </div>

    <!-- eSIMs List -->
    <div class="esims-section">

        <?php if (empty($esims)): ?>
            <div class="no-esims">
                <i class="fas fa-inbox"></i>
                <h3>هنوز eSIM ندارید!</h3>
                <p>برای خرید eSIM به صفحه اصلی بروید</p>
                <a href="/" class="btn">
                    <i class="fas fa-shopping-cart"></i>
                    خرید eSIM
                </a>
            </div>
        <?php else: ?>
            <div class="esims-grid">
                <?php foreach ($esims as $esim): 
                    // Get flag
                    $countryCode = strtolower($esim['country_code']);
                    $flagUrl = "https://flagcdn.com/w160/{$countryCode}.png";
                ?>
                <div class="esim-card">
                    <div class="esim-header">
                        <div class="esim-flag">
                            <img src="<?php echo $flagUrl; ?>" alt="<?php echo htmlspecialchars($esim['country_name']); ?>">
                        </div>
                        <div class="esim-title">
                            <div class="esim-country"><?php echo htmlspecialchars($esim['country_name']); ?></div>
                            <div class="esim-package"><?php echo htmlspecialchars($esim['package_name']); ?></div>
                        </div>
                    </div>

                    <div class="esim-body">
                        <div class="esim-info-row">
                            <span class="esim-info-label">حجم داده:</span>
                            <span class="esim-info-value"><?php echo htmlspecialchars($esim['data_amount']); ?></span>
                        </div>
                        <div class="esim-info-row">
                            <span class="esim-info-label">اعتبار:</span>
                            <span class="esim-info-value"><?php echo $esim['validity_days']; ?> روز</span>
                        </div>
                        <div class="esim-info-row">
                            <span class="esim-info-label">تاریخ خرید:</span>
                            <span class="esim-info-value"><?php echo date('Y/m/d', strtotime($esim['created_at'])); ?></span>
                        </div>
                        <?php if (!empty($esim['iccid'])): ?>
                        <div class="esim-info-row">
                            <span class="esim-info-label">ICCID:</span>
                            <span class="esim-info-value"><?php echo substr($esim['iccid'], 0, 10); ?>...</span>
                        </div>
                        <?php endif; ?>
                    </div>

                    <div class="esim-actions">
                        <a href="/esim-details.php?id=<?php echo $esim['id']; ?>" class="btn btn-primary">
                            <i class="fas fa-info-circle"></i>
                            جزئیات
                        </a>
                        <?php if (!empty($esim['iccid'])): ?>
                        <a href="/buy-more-data.php?iccid=<?php echo urlencode($esim['iccid']); ?>" class="btn btn-success">
                            <i class="fas fa-plus-circle"></i>
                            شارژ
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
