<?php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/otp-service.php';

// Only allow POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);
$phone = $input['phone'] ?? '';

// Validate phone
$phone = convertPersianToEnglish($phone);
if (!validateMobile($phone)) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'شماره موبایل نامعتبر است']);
    exit;
}

// Send OTP
$otpService = new OTPService();
$result = $otpService->sendOTP($phone);

if ($result['success']) {
    echo json_encode([
        'status' => 'ok',
        'message' => 'sent',
        'data' => [
            'phone' => $phone,
            'expires_in' => $result['expires_in']
        ]
    ]);
} else {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => $result['message']
    ]);
}

