# 🔐 راه‌اندازی Token-Based Authentication برای WebView

این سیستم برای حل مشکل session در مرورگرهای داخلی وب‌اپ (WebView) طراحی شده است.

---

## 📋 مراحل نصب

### 1️⃣ ایجاد جدول auth_tokens

برای ایجاد جدول مورد نیاز، یکی از روش‌های زیر را انتخاب کنید:

#### روش الف: از طریق مرورگر
1. فایل `create-auth-tokens-table.php` را آپلود کنید
2. به آدرس زیر بروید:
   ```
   https://esim.matinacard.com/create-auth-tokens-table.php
   ```
3. پس از اجرا، فایل را **حذف کنید** (برای امنیت)

#### روش ب: از طریق phpMyAdmin
در phpMyAdmin این query را اجرا کنید:

```sql
CREATE TABLE IF NOT EXISTS auth_tokens (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    token VARCHAR(64) NOT NULL UNIQUE,
    expires_at DATETIME NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_token (token),
    INDEX idx_user_id (user_id),
    INDEX idx_expires_at (expires_at),
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
```

---

## ✅ چگونه کار می‌کند؟

### 1. لاگین
زمانی که کاربر لاگین می‌کند:
- یک token تصادفی 64 کاراکتری ایجاد می‌شود
- token در دیتابیس ذخیره می‌شود (اعتبار 30 روز)
- token در `localStorage` مرورگر ذخیره می‌شود
- کاربر با token به dashboard هدایت می‌شود

### 2. احراز هویت
در هر درخواست، سیستم به ترتیب بررسی می‌کند:
1. ✅ Session موجود است؟ → ورود موفق
2. ✅ Token در URL (`?token=...`) موجود است؟ → بررسی و ورود
3. ✅ Token در POST data موجود است؟ → بررسی و ورود
4. ✅ Token در Authorization header موجود است؟ → بررسی و ورود
5. ❌ هیچ‌کدام → هدایت به صفحه لاگین

### 3. خودکار کردن
فایل `assets/js/auth-token.js` به صورت خودکار:
- Token را به تمام لینک‌های داخلی اضافه می‌کند
- Token را به تمام فرم‌ها اضافه می‌کند
- Token را به درخواست‌های fetch اضافه می‌کند

---

## 🔧 تنظیمات اضافی (اختیاری)

### مدت اعتبار Token
برای تغییر مدت اعتبار token (پیش‌فرض 30 روز):

در `api/verify-otp.php` و `api/register-user.php`:
```php
$expiresAt = date('Y-m-d H:i:s', strtotime('+30 days')); // تغییر دهید
```

### پاک‌سازی Token های منقضی
یک Cron Job برای پاک‌سازی token های قدیمی:

```sql
DELETE FROM auth_tokens WHERE expires_at < NOW();
```

---

## 🧪 تست کردن

### 1. در مرورگر عادی
- لاگین کنید
- باید بدون مشکل وارد dashboard شوید
- Session کار می‌کند

### 2. در WebView / وب‌اپ
- لاگین کنید
- توکن در localStorage ذخیره می‌شود
- تمام صفحات با token کار می‌کنند
- حتی اگر cookie کار نکند، token از URL خوانده می‌شود

---

## 🔍 Debug

اگر مشکلی وجود داشت، این موارد را بررسی کنید:

### 1. بررسی localStorage
در Console مرورگر:
```javascript
localStorage.getItem('auth_token')
```

### 2. بررسی token در دیتابیس
```sql
SELECT * FROM auth_tokens WHERE expires_at > NOW();
```

### 3. بررسی لاگ خطا
در مرورگر Console را باز کنید و خطاها را بررسی کنید.

---

## 📱 سازگاری

این سیستم با موارد زیر سازگار است:
- ✅ مرورگرهای عادی (Chrome, Firefox, Safari, Edge)
- ✅ WebView در اپلیکیشن‌های Android
- ✅ WKWebView در اپلیکیشن‌های iOS
- ✅ Progressive Web Apps (PWA)
- ✅ Electron Apps

---

## 🛡️ امنیت

- ✅ Token ها 64 کاراکتر تصادفی هستند (cryptographically secure)
- ✅ Token ها تاریخ انقضا دارند (30 روز)
- ✅ Token ها در دیتابیس UNIQUE هستند
- ✅ Token های منقضی شده قابل استفاده نیستند
- ✅ زمانی که کاربر حذف شود، token های او هم حذف می‌شوند (CASCADE)

---

## 🔄 Logout

برای logout کردن و حذف token:

```javascript
// در مرورگر
localStorage.removeItem('auth_token');
localStorage.removeItem('user_data');
```

یا در backend:
```php
// حذف token از دیتابیس
$conn = getDBConnection();
$stmt = $conn->prepare("DELETE FROM auth_tokens WHERE user_id = ?");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
```

---

## ✨ مزایا

1. **سازگاری کامل با WebView**: دیگر مشکل session ندارید
2. **Offline Support**: token در localStorage ذخیره می‌شود
3. **امنیت**: token ها منقضی می‌شوند
4. **سادگی**: به صورت خودکار به همه‌جا اضافه می‌شود
5. **Backward Compatible**: session های قدیمی همچنان کار می‌کنند

---

## 📞 پشتیبانی

اگر سوالی داشتید یا مشکلی پیش آمد، با تیم پشتیبانی تماس بگیرید.

---

**نکته مهم:** پس از ایجاد جدول، حتماً فایل `create-auth-tokens-table.php` را حذف کنید! 🔒

