# 📖 راهنمای نصب کامل سیستم eSIM

---

## 🎯 مراحل نصب به ترتیب

### مرحله 1️⃣: آماده‌سازی

#### نیازمندی‌ها:
- ✅ سرور آلمان با PHP 7.4+ و MySQL
- ✅ سرور ایران با PHP 7.4+ (برای proxy)
- ✅ حساب ZarinPal با Merchant ID
- ✅ حساب eSIM Access با Access Code و Security Key

---

### مرحله 2️⃣: آپلود فایل‌ها

#### روی سرور آلمان (esim.matinacard.com):

تمام فایل‌ها را **به جز** `proxy-handler.php` آپلود کنید:

```
✅ config/
✅ includes/
✅ api/
✅ admin/
✅ index.php
✅ login.php
✅ checkout.php
✅ dashboard.php
✅ order-view.php
✅ proxy-payment.php
✅ proxy-callback.php
✅ logout.php
✅ install.php
✅ .htaccess
❌ proxy-handler.php (این فایل نباید اینجا باشد)
```

#### روی سرور ایران (payesim.matinacard.ir):

**فقط** فایل `proxy-handler.php` را آپلود کنید:

```
✅ proxy-handler.php
```

---

### مرحله 3️⃣: تنظیم دیتابیس

#### 1. ساخت دیتابیس

در cPanel یا phpMyAdmin یک دیتابیس جدید بسازید:

```
نام دیتابیس: matin_esim
کاربر: matin_esim
رمز: [رمز امن انتخاب کنید]
```

#### 2. ویرایش config/database.php

```php
define('DB_HOST', 'localhost');
define('DB_USER', 'matin_esim');
define('DB_PASS', 'YOUR_SECURE_PASSWORD');
define('DB_NAME', 'matin_esim');
```

---

### مرحله 4️⃣: تنظیم API ها

#### 1. eSIM Access API

فایل `config/config.php` را ویرایش کنید:

```php
define('ESIM_ACCESS_CODE', '33335253e83a461ab9b7cdd2403983a1');
define('ESIM_SECURITY_KEY', '1adc4efb0c944b8185a68d0efa75c042');
```

#### 2. ZarinPal (روی سرور ایران)

فایل `proxy-handler.php` را ویرایش کنید:

```php
define('ZARINPAL_MERCHANT_ID', 'YOUR_ZARINPAL_MERCHANT_ID');
```

⚠️ **مهم:** Merchant ID را از پنل زرین‌پال خود دریافت کنید

---

### مرحله 5️⃣: نصب دیتابیس

#### 1. باز کردن صفحه نصب

در مرورگر به آدرس زیر بروید:

```
https://esim.matinacard.com/install.php
```

#### 2. کلیک روی دکمه "شروع نصب"

این کار موارد زیر را انجام می‌دهد:
- ✅ ساخت جدول users
- ✅ ساخت جدول orders
- ✅ ساخت جدول settings
- ✅ ایجاد حساب مدیر
- ✅ تنظیم نرخ ارز پیش‌فرض
- ✅ تنظیم ZarinPal

#### 3. اطلاعات ورود مدیر

```
موبایل: 09123456789
رمز عبور: admin123
```

⚠️ **مهم:** بعد از اولین ورود، حتماً رمز را تغییر دهید!

---

### مرحله 6️⃣: تست سیستم

#### 1. تست صفحه اصلی

```
https://esim.matinacard.com
```

باید لیست بسته‌ها نمایش داده شود.

#### 2. تست ورود

```
https://esim.matinacard.com/login
```

با اطلاعات مدیر وارد شوید.

#### 3. تست خرید

- یک بسته را انتخاب کنید
- به صفحه checkout بروید
- با حساب خود وارد شوید
- روی دکمه پرداخت کلیک کنید

#### 4. تست Proxy

باید به صفحه `proxy-payment.php` منتقل شوید و سپس:
- درخواست به سرور ایران ارسال شود
- لینک ZarinPal دریافت شود
- به درگاه ZarinPal منتقل شوید

---

### مرحله 7️⃣: تنظیمات امنیتی

#### 1. حذف/محافظت install.php

بعد از نصب، فایل `install.php` را حذف یا rename کنید:

```bash
mv install.php install.php.bak
```

یا در `.htaccess` محافظت کنید:

```apache
<Files install.php>
    Order allow,deny
    Deny from all
</Files>
```

#### 2. تغییر رمز مدیر

از داشبورد یا دیتابیس رمز مدیر را تغییر دهید.

#### 3. بررسی مجوزهای فایل‌ها

```bash
chmod 644 *.php
chmod 755 config/
chmod 644 config/*.php
chmod 644 includes/*.php
```

---

### مرحله 8️⃣: تنظیمات اختیاری

#### 1. تنظیم نرخ دلار

در دیتابیس یا از پنل مدیریت:

```sql
UPDATE settings SET setting_value = '650000' WHERE setting_key = 'usd_to_irr';
```

#### 2. فعال/غیرفعال Sandbox ZarinPal

```sql
UPDATE settings SET setting_value = '0' WHERE setting_key = 'zarinpal_sandbox';
```

مقدار `1` = Sandbox (تست)
مقدار `0` = Production (واقعی)

#### 3. تنظیم SMTP برای ایمیل (اختیاری)

می‌توانید PHPMailer یا SMTP را برای ارسال ایمیل اضافه کنید.

---

## 🔍 بررسی و تست

### ✅ چک‌لیست نصب موفق:

- [ ] صفحه اصلی بسته‌ها را نشان می‌دهد
- [ ] ورود/ثبت‌نام کار می‌کند
- [ ] صفحه checkout باز می‌شود
- [ ] انتقال به proxy-payment انجام می‌شود
- [ ] سرور ایران با ZarinPal ارتباط دارد
- [ ] callback به سرور آلمان برمی‌گردد
- [ ] eSIM از API دریافت می‌شود
- [ ] QR Code نمایش داده می‌شود

### ❌ مشکلات رایج:

#### خطای اتصال دیتابیس:
```
✅ اطلاعات دیتابیس را چک کنید
✅ مجوزهای کاربر را بررسی کنید
✅ نام دیتابیس را تایید کنید
```

#### خطای session:
```
✅ مطمئن شوید قبل از <?php هیچ فضای خالی نیست
✅ BOM را از فایل‌ها حذف کنید
```

#### خطای 500:
```
✅ error_log سرور را چک کنید
✅ مجوزهای فایل‌ها را بررسی کنید
✅ PHP version را تایید کنید (7.4+)
```

#### خطای proxy:
```
✅ URL سرور ایران را در config.php چک کنید
✅ proxy-handler.php روی سرور ایران آپلود شده باشد
✅ فایروال سرور ایران را چک کنید
```

#### خطای ZarinPal:
```
✅ Merchant ID را تایید کنید
✅ اتصال سرور ایران به ZarinPal را بررسی کنید
✅ callback_url صحیح باشد
```

---

## 📊 مانیتورینگ

### لاگ‌های مهم:

#### 1. PHP Error Log
```bash
tail -f /path/to/php_error.log
```

#### 2. MySQL Error Log
```bash
tail -f /var/log/mysql/error.log
```

#### 3. Apache/Nginx Access Log
```bash
tail -f /var/log/apache2/access.log
# یا
tail -f /var/log/nginx/access.log
```

---

## 🎉 نصب کامل شد!

حالا سیستم شما آماده است:

1. ✅ کاربران می‌توانند ثبت‌نام کنند
2. ✅ بسته‌ها را مشاهده کنند
3. ✅ خرید کنند
4. ✅ پرداخت انجام دهند
5. ✅ eSIM دریافت کنند

---

## 📞 پشتیبانی

در صورت بروز مشکل:
- 📧 Email: support@matinacard.com
- 📱 Telegram: @matinacard
- 🌐 Website: https://esim.matinacard.com

---

**موفق باشید! 🚀**

