<?php
/**
 * Update IPPanel Pattern Code
 * This file updates the pattern code in database
 * Run once and then DELETE this file!
 */

require_once __DIR__ . '/config/config.php';

// New pattern code
$newPatternCode = 'lourive2zquwy5h';

// Update in database
$result = updateSetting('ippanel_pattern_code', $newPatternCode);

if ($result) {
    echo "✅ <strong>موفق!</strong><br>";
    echo "کد پترن با موفقیت به <code>{$newPatternCode}</code> تغییر کرد.<br><br>";
    
    // Verify
    $currentCode = getSetting('ippanel_pattern_code', '');
    echo "✅ تایید: کد پترن فعلی = <code>{$currentCode}</code><br><br>";
    
    echo "<hr>";
    echo "<strong style='color: red;'>⚠️ مهم: حالا این فایل را حذف کنید!</strong><br>";
    echo "<code>update-pattern-code.php</code><br><br>";
    
    echo "<a href='/otp-settings.php'>👉 رفتن به تنظیمات OTP</a>";
} else {
    echo "❌ <strong>خطا!</strong><br>";
    echo "مشکلی در بروزرسانی پیش آمد. لطفاً دستی از طریق phpMyAdmin تغییر دهید:<br><br>";
    echo "<code>UPDATE settings SET setting_value = '{$newPatternCode}' WHERE setting_key = 'ippanel_pattern_code';</code>";
}
?>

<style>
body {
    font-family: 'Tahoma', Arial, sans-serif;
    direction: rtl;
    text-align: right;
    padding: 40px;
    background: #f5f5f5;
}
code {
    background: #333;
    color: #0f0;
    padding: 5px 10px;
    border-radius: 5px;
    font-size: 16px;
}
strong {
    font-size: 18px;
}
a {
    display: inline-block;
    background: #4CAF50;
    color: white;
    padding: 10px 20px;
    text-decoration: none;
    border-radius: 5px;
    margin-top: 20px;
}
a:hover {
    background: #45a049;
}
hr {
    margin: 30px 0;
    border: none;
    border-top: 2px solid #ddd;
}
</style>

