<?php
/**
 * صفحه تست احراز هویت با Token
 * این صفحه برای تست کردن سیستم Token است
 */
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';

$pageTitle = 'تست احراز هویت';
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?></title>
    <link rel="stylesheet" href="/assets/css/vazirmatn-font.css">
    <script src="/assets/js/auth-token.js"></script>
    <style>
        body {
            font-family: 'Vazirmatn', Arial, sans-serif;
            padding: 20px;
            background: #f5f5f5;
            direction: rtl;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .status {
            padding: 15px;
            border-radius: 5px;
            margin: 10px 0;
        }
        .success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .info {
            background: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
        }
        pre {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
            direction: ltr;
            text-align: left;
        }
        .btn {
            display: inline-block;
            padding: 10px 20px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 5px;
            border: none;
            cursor: pointer;
        }
        .btn:hover {
            background: #5568d3;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔐 تست احراز هویت با Token</h1>
        
        <h2>📊 وضعیت فعلی</h2>
        
        <?php if (isLoggedIn()): ?>
            <div class="status success">
                <h3>✅ شما لاگین هستید!</h3>
                <p><strong>User ID:</strong> <?php echo $_SESSION['user_id'] ?? 'N/A'; ?></p>
                <p><strong>Mobile:</strong> <?php echo $_SESSION['mobile'] ?? 'N/A'; ?></p>
                <p><strong>Email:</strong> <?php echo $_SESSION['email'] ?? 'N/A'; ?></p>
                <p><strong>Is Admin:</strong> <?php echo ($_SESSION['is_admin'] ?? 0) ? 'بله' : 'خیر'; ?></p>
            </div>
        <?php else: ?>
            <div class="status error">
                <h3>❌ شما لاگین نیستید</h3>
                <p>لطفاً ابتدا وارد شوید.</p>
                <a href="/login-otp.php" class="btn">ورود / ثبت‌نام</a>
            </div>
        <?php endif; ?>
        
        <h2>🔍 اطلاعات درخواست</h2>
        <div class="status info">
            <h3>Session Data:</h3>
            <pre><?php print_r($_SESSION); ?></pre>
            
            <h3>GET Parameters:</h3>
            <pre><?php print_r($_GET); ?></pre>
            
            <h3>POST Parameters:</h3>
            <pre><?php print_r($_POST); ?></pre>
            
            <h3>Headers:</h3>
            <pre><?php 
            $headers = getallheaders();
            print_r($headers); 
            ?></pre>
        </div>
        
        <h2>💾 localStorage Token (JavaScript)</h2>
        <div id="tokenInfo" class="status info">
            <p>در حال بررسی...</p>
        </div>
        
        <h2>🧪 تست‌ها</h2>
        <button class="btn" onclick="testTokenInURL()">تست Token در URL</button>
        <button class="btn" onclick="testTokenInForm()">تست Token در Form</button>
        <button class="btn" onclick="clearToken()">پاک کردن Token</button>
        <button class="btn" onclick="location.reload()">رفرش صفحه</button>
        
        <div id="testResults"></div>
    </div>
    
    <script>
        // نمایش Token از localStorage
        function displayTokenInfo() {
            const token = localStorage.getItem('auth_token');
            const userData = localStorage.getItem('user_data');
            const container = document.getElementById('tokenInfo');
            
            if (token) {
                container.innerHTML = `
                    <h3>✅ Token موجود است</h3>
                    <p><strong>Token:</strong> <code>${token.substring(0, 30)}...</code></p>
                    ${userData ? `<p><strong>User Data:</strong></p><pre>${userData}</pre>` : ''}
                `;
                container.className = 'status success';
            } else {
                container.innerHTML = `
                    <h3>❌ Token موجود نیست</h3>
                    <p>هیچ توکنی در localStorage ذخیره نشده است.</p>
                `;
                container.className = 'status error';
            }
        }
        
        // تست Token در URL
        function testTokenInURL() {
            const token = localStorage.getItem('auth_token');
            if (token) {
                window.location.href = '/test-token-auth.php?token=' + token;
            } else {
                alert('هیچ توکنی یافت نشد!');
            }
        }
        
        // تست Token در Form
        function testTokenInForm() {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '/test-token-auth.php';
            
            const token = localStorage.getItem('auth_token');
            if (token) {
                const input = document.createElement('input');
                input.type = 'hidden';
                input.name = 'token';
                input.value = token;
                form.appendChild(input);
                
                document.body.appendChild(form);
                form.submit();
            } else {
                alert('هیچ توکنی یافت نشد!');
            }
        }
        
        // پاک کردن Token
        function clearToken() {
            localStorage.removeItem('auth_token');
            localStorage.removeItem('user_data');
            alert('Token پاک شد!');
            location.reload();
        }
        
        // اجرا بعد از لود صفحه
        displayTokenInfo();
    </script>
</body>
</html>

