<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/api/esim-api.php';

echo "<h1>🔍 Simple API Test</h1>";
echo "<style>body { font-family: Arial; padding: 20px; } pre { background: #f5f5f5; padding: 15px; border-radius: 8px; }</style>";
echo "<hr>";

// Get orders from database
$conn = getDBConnection();
$result = $conn->query("SELECT id, iccid, package_name FROM orders WHERE status = 'paid' AND iccid IS NOT NULL AND iccid != '' ORDER BY id DESC LIMIT 1");

if ($result && $result->num_rows > 0) {
    $order = $result->fetch_assoc();
    
    echo "<h2>✅ Found Order:</h2>";
    echo "<ul>";
    echo "<li><strong>Order ID:</strong> " . $order['id'] . "</li>";
    echo "<li><strong>Package:</strong> " . htmlspecialchars($order['package_name']) . "</li>";
    echo "<li><strong>ICCID:</strong> <code>" . htmlspecialchars($order['iccid']) . "</code></li>";
    echo "</ul>";
    
    echo "<hr>";
    echo "<h2>🧪 Testing API queryProfile...</h2>";
    
    $api = new eSIMAPI();
    $response = $api->queryProfile($order['iccid']);
    
    if ($response === false) {
        echo "<p style='color: red;'>❌ API returned FALSE</p>";
    } elseif (isset($response['code'])) {
        echo "<p><strong>Response Code:</strong> " . $response['code'] . "</p>";
        echo "<p><strong>Response Message:</strong> " . ($response['msg'] ?? 'N/A') . "</p>";
        
        if ($response['code'] == 0) {
            echo "<p style='color: green; font-weight: bold;'>✅ Success!</p>";
            
            if (isset($response['obj']['esimList']) && !empty($response['obj']['esimList'])) {
                $esim = $response['obj']['esimList'][0];
                
                echo "<h3>📱 eSIM Data:</h3>";
                echo "<ul>";
                echo "<li><strong>Status:</strong> " . ($esim['status'] ?? 'N/A') . "</li>";
                echo "<li><strong>ICCID:</strong> " . ($esim['iccid'] ?? 'N/A') . "</li>";
                
                if (isset($esim['dataUsage'])) {
                    $total = $esim['dataUsage']['total'] ?? 0;
                    $used = $esim['dataUsage']['used'] ?? 0;
                    $totalGB = round($total / 1024 / 1024 / 1024, 2);
                    $usedGB = round($used / 1024 / 1024 / 1024, 2);
                    
                    echo "<li><strong>Total:</strong> {$totalGB} GB</li>";
                    echo "<li><strong>Used:</strong> {$usedGB} GB</li>";
                }
                
                echo "<li><strong>Network:</strong> " . ($esim['network'] ?? 'N/A') . "</li>";
                echo "<li><strong>Activation Time:</strong> " . ($esim['activationTime'] ?? 'N/A') . "</li>";
                echo "<li><strong>Expire Time:</strong> " . ($esim['expireTime'] ?? 'N/A') . "</li>";
                echo "</ul>";
                
                echo "<hr>";
                echo "<h3>📋 Full Response (compact):</h3>";
                echo "<pre>";
                echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
                echo "</pre>";
            } else {
                echo "<p style='color: orange;'>⚠️ esimList is empty or not found</p>";
                echo "<pre>";
                print_r($response);
                echo "</pre>";
            }
        } else {
            echo "<p style='color: red;'>❌ API Error</p>";
            echo "<pre>";
            print_r($response);
            echo "</pre>";
        }
    } else {
        echo "<p style='color: red;'>❌ Invalid response format</p>";
        echo "<pre>";
        print_r($response);
        echo "</pre>";
    }
} else {
    echo "<p style='color: red;'>❌ No paid orders with ICCID found in database</p>";
    echo "<p>Please complete a purchase first to test the API.</p>";
}

$conn->close();
?>

