<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/api/esim-api.php';

echo "<h1>Checkout Test</h1>";

// Test 1: Check if logged in
echo "<h2>1. Login Status</h2>";
if (isLoggedIn()) {
    echo "<p style='color: green;'>✅ User is logged in</p>";
    echo "<p><strong>User ID:</strong> " . $_SESSION['user_id'] . "</p>";
    echo "<p><strong>Mobile:</strong> " . htmlspecialchars($_SESSION['mobile']) . "</p>";
    echo "<p><strong>Email:</strong> " . htmlspecialchars($_SESSION['email'] ?? 'N/A') . "</p>";
} else {
    echo "<p style='color: red;'>❌ User is NOT logged in</p>";
    echo "<p><a href='/login.php'>Login here</a></p>";
    exit;
}

// Test 2: Get a sample package
echo "<h2>2. Get Sample Package</h2>";
$packageCode = $_GET['package'] ?? 'CKH031'; // Default test package
$countryCode = $_GET['country'] ?? 'AE'; // Default test country

echo "<p><strong>Package Code:</strong> " . htmlspecialchars($packageCode) . "</p>";
echo "<p><strong>Country Code:</strong> " . htmlspecialchars($countryCode) . "</p>";

try {
    $api = new eSIMAPI();
    $allPackages = $api->getAllPackages();
    
    $package = null;
    if ($allPackages && isset($allPackages['obj']['packageList'])) {
        foreach ($allPackages['obj']['packageList'] as $pkg) {
            if ($pkg['packageCode'] == $packageCode) {
                $package = $pkg;
                break;
            }
        }
    }
    
    if ($package) {
        echo "<p style='color: green;'>✅ Package found</p>";
        echo "<p><strong>Package Name:</strong> " . htmlspecialchars($package['name']) . "</p>";
        echo "<p><strong>Price (API):</strong> " . $package['price'] . "</p>";
        echo "<p><strong>Volume:</strong> " . $package['volume'] . " bytes</p>";
        echo "<p><strong>Duration:</strong> " . $package['duration'] . " days</p>";
    } else {
        echo "<p style='color: red;'>❌ Package not found</p>";
        exit;
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . htmlspecialchars($e->getMessage()) . "</p>";
    exit;
}

// Test 3: Calculate prices
echo "<h2>3. Price Calculation</h2>";
$priceUsd = $package['price'] / 10000;
$priceIrr = usdToIrr($priceUsd);
$volumeGB = round($package['volume'] / 1073741824, 1);
$dataDisplay = $volumeGB . ' GB';

echo "<p><strong>Price USD:</strong> $" . number_format($priceUsd, 2) . "</p>";
echo "<p><strong>Price IRR (Toman):</strong> " . number_format($priceIrr) . " تومان</p>";
echo "<p><strong>Price IRR (Rials):</strong> " . number_format($priceIrr * 10) . " ریال</p>";
echo "<p><strong>Data Display:</strong> " . $dataDisplay . "</p>";

// Test 4: Get country name
echo "<h2>4. Country Info</h2>";
$countries = require __DIR__ . '/data/countries.php';
$countryName = $countryCode;
foreach ($countries as $country) {
    if ($country['iso'] == $countryCode) {
        $countryName = $country['name'];
        break;
    }
}
echo "<p><strong>Country Name:</strong> " . htmlspecialchars($countryName) . "</p>";

// Test 5: Create order
echo "<h2>5. Create Test Order</h2>";

if (isset($_POST['create_order'])) {
    $orderData = [
        'country_code' => $countryCode,
        'country_name' => $countryName,
        'package_name' => $package['name'],
        'package_code' => $packageCode,
        'data_amount' => $dataDisplay,
        'validity_days' => (int)$package['duration']
    ];
    
    $orderId = createOrder($_SESSION['user_id'], $orderData, $priceUsd);
    
    if ($orderId) {
        echo "<p style='color: green; font-size: 20px;'>✅ Order created successfully!</p>";
        echo "<p><strong>Order ID:</strong> " . $orderId . "</p>";
        echo "<p><a href='/debug-payment.php?order=" . $orderId . "' style='background: #667eea; color: white; padding: 15px 30px; text-decoration: none; border-radius: 8px; display: inline-block;'>Test Payment for this Order</a></p>";
        echo "<p><a href='/proxy-payment.php?order=" . $orderId . "' style='background: #28a745; color: white; padding: 15px 30px; text-decoration: none; border-radius: 8px; display: inline-block; margin-top: 10px;'>Go to Real Payment</a></p>";
    } else {
        echo "<p style='color: red;'>❌ Failed to create order</p>";
    }
} else {
    echo "<form method='POST'>";
    echo "<p><strong>Order Data:</strong></p>";
    echo "<pre>";
    echo "Country: " . htmlspecialchars($countryName) . " (" . $countryCode . ")\n";
    echo "Package: " . htmlspecialchars($package['name']) . "\n";
    echo "Data: " . $dataDisplay . "\n";
    echo "Duration: " . $package['duration'] . " days\n";
    echo "Price: " . number_format($priceIrr) . " تومان\n";
    echo "</pre>";
    echo "<button type='submit' name='create_order' style='background: #667eea; color: white; padding: 15px 30px; border: none; border-radius: 8px; font-size: 16px; cursor: pointer;'>Create Test Order</button>";
    echo "</form>";
}

// Test 6: Check Iran server
echo "<h2>6. Iran Server Status</h2>";
echo "<p><strong>Iran Server URL:</strong> " . IRAN_SERVER_URL . "</p>";

$ch = curl_init(IRAN_SERVER_URL);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 5);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

if ($httpCode === 200) {
    echo "<p style='color: green;'>✅ Iran server is reachable (HTTP " . $httpCode . ")</p>";
} else {
    echo "<p style='color: red;'>❌ Iran server is NOT reachable (HTTP " . $httpCode . ")</p>";
    if ($curlError) {
        echo "<p style='color: red;'><strong>Error:</strong> " . htmlspecialchars($curlError) . "</p>";
    }
}

?>

<style>
body {
    font-family: Tahoma, Arial, sans-serif;
    padding: 20px;
    direction: rtl;
    max-width: 1000px;
    margin: 0 auto;
}
h1, h2 {
    color: #333;
    border-bottom: 2px solid #667eea;
    padding-bottom: 10px;
}
pre {
    background: #f5f5f5;
    padding: 15px;
    border-radius: 5px;
    overflow-x: auto;
    direction: ltr;
    text-align: left;
}
p {
    margin: 10px 0;
    line-height: 1.6;
}
</style>

