<?php
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'matin_esim');
define('DB_PASS', 'M0059418m');
define('DB_NAME', 'matin_esim');

// Create connection
function getDBConnection() {
    $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    
    $conn->set_charset("utf8mb4");
    return $conn;
}

// Initialize database tables
function initializeDatabase() {
    $conn = getDBConnection();
    
    // Users table
    $sql = "CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100) DEFAULT NULL,
        mobile VARCHAR(20) UNIQUE NOT NULL,
        email VARCHAR(100) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        is_admin TINYINT(1) DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    $conn->query($sql);
    
    // Orders table
    $sql = "CREATE TABLE IF NOT EXISTS orders (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        esim_id VARCHAR(100),
        country_code VARCHAR(10),
        country_name VARCHAR(100),
        package_name VARCHAR(255),
        package_code VARCHAR(100),
        data_amount VARCHAR(50),
        validity_days INT,
        price_usd DECIMAL(10,2),
        price_irr DECIMAL(15,2),
        status ENUM('pending', 'paid', 'failed', 'cancelled') DEFAULT 'pending',
        payment_authority VARCHAR(100),
        payment_ref_id VARCHAR(100),
        iccid VARCHAR(100),
        qr_code TEXT,
        activation_code TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        paid_at TIMESTAMP NULL,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $conn->query($sql);
    
    // Settings table
    $sql = "CREATE TABLE IF NOT EXISTS settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        setting_key VARCHAR(100) UNIQUE NOT NULL,
        setting_value TEXT,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $conn->query($sql);
    
    // OTP table for login/register verification
    $sql = "CREATE TABLE IF NOT EXISTS otp_codes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        mobile VARCHAR(20) NOT NULL,
        code VARCHAR(6) NOT NULL,
        type ENUM('login', 'register') DEFAULT 'login',
        is_used TINYINT(1) DEFAULT 0,
        expires_at TIMESTAMP NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        INDEX idx_mobile (mobile),
        INDEX idx_code (code),
        INDEX idx_expires (expires_at)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";
    $conn->query($sql);
    
    // Insert default settings
    $conn->query("INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('usd_to_irr', '10000')");
    $conn->query("INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('zarinpal_merchant', 'fe6fc16e-0927-4dcd-95fe-07614d9f79ff')");
    $conn->query("INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('zarinpal_sandbox', '1')");
    
    // Create default admin user (mobile: 09123456789, password: admin123)
    $admin_password = password_hash('admin123', PASSWORD_DEFAULT);
    $conn->query("INSERT IGNORE INTO users (mobile, email, password, is_admin) VALUES ('09123456789', 'admin@esim.com', '$admin_password', 1)");
    
    $conn->close();
}