<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';

// Check if user is logged in
if (!isLoggedIn()) {
    echo "<!DOCTYPE html><html><head><meta charset='UTF-8'></head><body>";
    echo "<h1>لطفاً ابتدا لاگین کنید</h1>";
    echo "<a href='/login.php'>ورود</a>";
    echo "</body></html>";
    exit;
}

$userId = $_SESSION['user_id'];
$conn = getDBConnection();

// Get all orders for this user
$stmt = $conn->prepare("SELECT id, package_name, country_name, status, qr_code, activation_code, iccid, created_at FROM orders WHERE user_id = ? ORDER BY created_at DESC");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$allOrders = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();

// Get paid orders
$stmt = $conn->prepare("SELECT id, package_name, country_name, status, qr_code, activation_code, iccid, created_at FROM orders WHERE user_id = ? AND status = 'paid' ORDER BY created_at DESC");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$paidOrders = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();

$conn->close();
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>بررسی سفارشات</title>
    <link rel="stylesheet" href="/assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <div class="container" style="margin-top: 2rem;">
        <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 2rem; border-radius: 12px; margin-bottom: 2rem;">
            <h1><i class="fas fa-database"></i> بررسی سفارشات دیتابیس</h1>
            <p>کاربر: <?php echo htmlspecialchars($_SESSION['mobile']); ?> (ID: <?php echo $userId; ?>)</p>
        </div>

        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.5rem; margin-bottom: 2rem;">
            <div style="background: white; padding: 1.5rem; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); text-align: center;">
                <i class="fas fa-shopping-cart" style="font-size: 3rem; color: #667eea; margin-bottom: 1rem;"></i>
                <h3 style="color: #2c3e50; margin-bottom: 0.5rem;">کل سفارشات</h3>
                <p style="font-size: 2rem; font-weight: bold; color: #667eea;"><?php echo count($allOrders); ?></p>
            </div>
            <div style="background: white; padding: 1.5rem; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); text-align: center;">
                <i class="fas fa-check-circle" style="font-size: 3rem; color: #4caf50; margin-bottom: 1rem;"></i>
                <h3 style="color: #2c3e50; margin-bottom: 0.5rem;">سفارشات پرداخت شده</h3>
                <p style="font-size: 2rem; font-weight: bold; color: #4caf50;"><?php echo count($paidOrders); ?></p>
            </div>
        </div>

        <?php if (count($allOrders) > 0): ?>
        <div style="background: white; padding: 2rem; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); margin-bottom: 2rem;">
            <h2 style="color: #2c3e50; margin-bottom: 1.5rem;">
                <i class="fas fa-list"></i> تمام سفارشات
            </h2>
            <div style="overflow-x: auto;">
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                            <th style="padding: 1rem; text-align: right;">شماره</th>
                            <th style="padding: 1rem; text-align: right;">بسته</th>
                            <th style="padding: 1rem; text-align: right;">کشور</th>
                            <th style="padding: 1rem; text-align: center;">وضعیت</th>
                            <th style="padding: 1rem; text-align: center;">QR Code</th>
                            <th style="padding: 1rem; text-align: center;">Activation Code</th>
                            <th style="padding: 1rem; text-align: center;">ICCID</th>
                            <th style="padding: 1rem; text-align: right;">تاریخ</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($allOrders as $order): ?>
                        <tr style="border-bottom: 1px solid #e0e0e0;">
                            <td style="padding: 1rem;">#<?php echo $order['id']; ?></td>
                            <td style="padding: 1rem;"><?php echo htmlspecialchars($order['package_name']); ?></td>
                            <td style="padding: 1rem;"><?php echo htmlspecialchars($order['country_name']); ?></td>
                            <td style="padding: 1rem; text-align: center;">
                                <?php
                                $statusColors = [
                                    'paid' => '#4caf50',
                                    'pending' => '#ff9800',
                                    'cancelled' => '#f44336'
                                ];
                                $color = $statusColors[$order['status']] ?? '#999';
                                ?>
                                <span style="background: <?php echo $color; ?>; color: white; padding: 0.3rem 0.8rem; border-radius: 20px; font-size: 0.85rem; font-weight: 600;">
                                    <?php echo $order['status']; ?>
                                </span>
                            </td>
                            <td style="padding: 1rem; text-align: center;">
                                <?php if (!empty($order['qr_code'])): ?>
                                    <i class="fas fa-check-circle" style="color: #4caf50; font-size: 1.5rem;"></i>
                                <?php else: ?>
                                    <i class="fas fa-times-circle" style="color: #f44336; font-size: 1.5rem;"></i>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 1rem; text-align: center;">
                                <?php if (!empty($order['activation_code'])): ?>
                                    <i class="fas fa-check-circle" style="color: #4caf50; font-size: 1.5rem;"></i>
                                <?php else: ?>
                                    <i class="fas fa-times-circle" style="color: #f44336; font-size: 1.5rem;"></i>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 1rem; text-align: center;">
                                <?php if (!empty($order['iccid'])): ?>
                                    <i class="fas fa-check-circle" style="color: #4caf50; font-size: 1.5rem;"></i>
                                <?php else: ?>
                                    <i class="fas fa-times-circle" style="color: #f44336; font-size: 1.5rem;"></i>
                                <?php endif; ?>
                            </td>
                            <td style="padding: 1rem;"><?php echo date('Y/m/d H:i', strtotime($order['created_at'])); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php else: ?>
        <div style="background: #fff3cd; padding: 3rem; border-radius: 12px; text-align: center;">
            <i class="fas fa-exclamation-triangle" style="font-size: 4rem; color: #856404; margin-bottom: 1rem;"></i>
            <h2 style="color: #856404;">هیچ سفارشی یافت نشد!</h2>
            <p style="color: #856404; margin: 1rem 0;">
                برای تست، یک سفارش جدید ایجاد کنید.
            </p>
            <a href="/" style="display: inline-block; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 1rem 2rem; border-radius: 8px; text-decoration: none; margin-top: 1rem;">
                <i class="fas fa-shopping-cart"></i> خرید eSIM
            </a>
        </div>
        <?php endif; ?>

        <div style="background: #d1ecf1; padding: 2rem; border-radius: 12px; margin-top: 2rem;">
            <h3 style="color: #0c5460;"><i class="fas fa-lightbulb"></i> نکات مهم:</h3>
            <ul style="color: #0c5460; line-height: 2;">
                <li><strong>QR Code:</strong> اگر ✓ سبز باشد، یعنی eSIM از API دریافت شده</li>
                <li><strong>Activation Code:</strong> کد فعال‌سازی دستی برای نصب eSIM</li>
                <li><strong>ICCID:</strong> شماره منحصر به فرد eSIM</li>
                <li><strong>Status = paid:</strong> فقط سفارشات پرداخت شده در صفحه My eSIMs نمایش داده می‌شوند</li>
            </ul>
        </div>

        <div style="display: flex; gap: 1rem; margin-top: 2rem; flex-wrap: wrap;">
            <a href="/my-esims.php" style="flex: 1; min-width: 200px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 1rem; border-radius: 8px; text-decoration: none; text-align: center;">
                <i class="fas fa-sim-card"></i> صفحه My eSIMs
            </a>
            <a href="/my-esims-debug.php" style="flex: 1; min-width: 200px; background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); color: white; padding: 1rem; border-radius: 8px; text-decoration: none; text-align: center;">
                <i class="fas fa-bug"></i> Debug Mode
            </a>
            <a href="/dashboard.php" style="flex: 1; min-width: 200px; background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); color: white; padding: 1rem; border-radius: 8px; text-decoration: none; text-align: center;">
                <i class="fas fa-th-large"></i> داشبورد
            </a>
        </div>
    </div>
</body>
</html>

