<?php
require_once __DIR__ . '/config/config.php';

// Check if user is logged in
if (!isLoggedIn()) {
    echo "Not logged in!";
    exit;
}

$userId = $_SESSION['user_id'];

echo "<h1>Database Check</h1>";
echo "<p><strong>User ID:</strong> " . $userId . "</p>";
echo "<p><strong>Mobile:</strong> " . htmlspecialchars($_SESSION['mobile']) . "</p>";

// Get connection
$conn = getDBConnection();

// Check total orders in database
$result = $conn->query("SELECT COUNT(*) as total FROM orders");
$row = $result->fetch_assoc();
echo "<p><strong>Total Orders in DB:</strong> " . $row['total'] . "</p>";

// Check user's orders
$stmt = $conn->prepare("SELECT COUNT(*) as total FROM orders WHERE user_id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
echo "<p><strong>User's Orders:</strong> " . $row['total'] . "</p>";
$stmt->close();

// Get user's orders details
$stmt = $conn->prepare("SELECT * FROM orders WHERE user_id = ? ORDER BY created_at DESC LIMIT 10");
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();
$orders = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();

if (!empty($orders)) {
    echo "<h2>User's Orders:</h2>";
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
    echo "<tr>";
    echo "<th>ID</th>";
    echo "<th>Package</th>";
    echo "<th>Country</th>";
    echo "<th>Price</th>";
    echo "<th>Status</th>";
    echo "<th>Created At</th>";
    echo "</tr>";
    
    foreach ($orders as $order) {
        echo "<tr>";
        echo "<td>" . $order['id'] . "</td>";
        echo "<td>" . htmlspecialchars($order['package_name']) . "</td>";
        echo "<td>" . htmlspecialchars($order['country_name']) . "</td>";
        echo "<td>" . number_format($order['price_irr']) . " تومان</td>";
        echo "<td>" . $order['status'] . "</td>";
        echo "<td>" . $order['created_at'] . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
} else {
    echo "<p style='color: red;'>No orders found for this user!</p>";
    
    // Show all orders
    $result = $conn->query("SELECT * FROM orders ORDER BY created_at DESC LIMIT 10");
    $allOrders = $result->fetch_all(MYSQLI_ASSOC);
    
    if (!empty($allOrders)) {
        echo "<h2>All Orders in Database:</h2>";
        echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
        echo "<tr>";
        echo "<th>ID</th>";
        echo "<th>User ID</th>";
        echo "<th>Package</th>";
        echo "<th>Country</th>";
        echo "<th>Price</th>";
        echo "<th>Status</th>";
        echo "<th>Created At</th>";
        echo "</tr>";
        
        foreach ($allOrders as $order) {
            echo "<tr>";
            echo "<td>" . $order['id'] . "</td>";
            echo "<td>" . $order['user_id'] . "</td>";
            echo "<td>" . htmlspecialchars($order['package_name']) . "</td>";
            echo "<td>" . htmlspecialchars($order['country_name']) . "</td>";
            echo "<td>" . number_format($order['price_irr']) . " تومان</td>";
            echo "<td>" . $order['status'] . "</td>";
            echo "<td>" . $order['created_at'] . "</td>";
            echo "</tr>";
        }
        
        echo "</table>";
    }
}

$conn->close();
?>

<style>
body {
    font-family: Tahoma, Arial, sans-serif;
    padding: 20px;
    direction: rtl;
}
table {
    width: 100%;
    margin-top: 20px;
}
th {
    background: #667eea;
    color: white;
    padding: 10px;
}
td {
    padding: 8px;
}
tr:nth-child(even) {
    background: #f8f9fa;
}
</style>

