// Country Search
document.addEventListener('DOMContentLoaded', function() {
    const countrySearch = document.getElementById('countrySearch');
    if (countrySearch) {
        countrySearch.addEventListener('input', function(e) {
            const searchTerm = e.target.value.toLowerCase();
            const countryCards = document.querySelectorAll('.country-card');
            
            countryCards.forEach(card => {
                const countryName = card.getAttribute('data-name').toLowerCase();
                if (countryName.includes(searchTerm)) {
                    card.style.display = 'block';
                } else {
                    card.style.display = 'none';
                }
            });
        });
    }
    
    // Package Filters
    const dataFilter = document.getElementById('dataFilter');
    const daysFilter = document.getElementById('daysFilter');
    const sortBy = document.getElementById('sortBy');
    
    if (dataFilter || daysFilter || sortBy) {
        const filterPackages = () => {
            const packageCards = document.querySelectorAll('.package-card');
            let visibleCards = Array.from(packageCards);
            
            // Apply data filter
            if (dataFilter && dataFilter.value) {
                const filterValue = parseInt(dataFilter.value);
                visibleCards = visibleCards.filter(card => {
                    const dataMB = parseInt(card.getAttribute('data-data'));
                    const dataGB = dataMB / 1024;
                    
                    if (filterValue === 20) {
                        return dataGB >= 20;
                    } else {
                        return dataGB >= filterValue && dataGB < (filterValue + 2);
                    }
                });
            }
            
            // Apply days filter
            if (daysFilter && daysFilter.value) {
                const filterValue = parseInt(daysFilter.value);
                visibleCards = visibleCards.filter(card => {
                    const days = parseInt(card.getAttribute('data-days'));
                    
                    if (filterValue === 60) {
                        return days >= 60;
                    } else {
                        return days === filterValue;
                    }
                });
            }
            
            // Hide all cards first
            packageCards.forEach(card => card.style.display = 'none');
            
            // Sort cards
            if (sortBy && sortBy.value) {
                const sortValue = sortBy.value;
                
                visibleCards.sort((a, b) => {
                    if (sortValue === 'price-asc') {
                        return parseFloat(a.getAttribute('data-price')) - parseFloat(b.getAttribute('data-price'));
                    } else if (sortValue === 'price-desc') {
                        return parseFloat(b.getAttribute('data-price')) - parseFloat(a.getAttribute('data-price'));
                    } else if (sortValue === 'data-asc') {
                        return parseFloat(a.getAttribute('data-data')) - parseFloat(b.getAttribute('data-data'));
                    } else if (sortValue === 'data-desc') {
                        return parseFloat(b.getAttribute('data-data')) - parseFloat(a.getAttribute('data-data'));
                    }
                    return 0;
                });
            }
            
            // Show filtered and sorted cards
            const grid = document.getElementById('packagesGrid');
            if (grid) {
                visibleCards.forEach(card => {
                    card.style.display = 'block';
                    grid.appendChild(card);
                });
            }
        };
        
        if (dataFilter) dataFilter.addEventListener('change', filterPackages);
        if (daysFilter) daysFilter.addEventListener('change', filterPackages);
        if (sortBy) sortBy.addEventListener('change', filterPackages);
    }
    
    // Mobile Menu Toggle
    const mobileMenuToggle = document.querySelector('.mobile-menu-toggle');
    const navMenu = document.querySelector('.nav-menu');
    
    if (mobileMenuToggle && navMenu) {
        mobileMenuToggle.addEventListener('click', () => {
            navMenu.classList.toggle('active');
        });
    }
});

// Copy to Clipboard
function copyToClipboard(text) {
    if (navigator.clipboard) {
        navigator.clipboard.writeText(text).then(() => {
            alert('کد فعال‌سازی کپی شد');
        }).catch(err => {
            console.error('Failed to copy:', err);
        });
    } else {
        // Fallback for older browsers
        const textarea = document.createElement('textarea');
        textarea.value = text;
        textarea.style.position = 'fixed';
        textarea.style.opacity = '0';
        document.body.appendChild(textarea);
        textarea.select();
        try {
            document.execCommand('copy');
            alert('کد فعال‌سازی کپی شد');
        } catch (err) {
            console.error('Failed to copy:', err);
        }
        document.body.removeChild(textarea);
    }
}

// Toggle Installation Instructions
function toggleInstructions(esimId) {
    const instructions = document.getElementById('instructions-' + esimId);
    if (instructions) {
        if (instructions.style.display === 'none') {
            instructions.style.display = 'block';
        } else {
            instructions.style.display = 'none';
        }
    }
}

// View User Orders (Admin)
function viewUserOrders(userId) {
    window.location.href = '/admin/orders.php?user=' + userId;
}

// Auto-hide alerts after 5 seconds
document.addEventListener('DOMContentLoaded', function() {
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        setTimeout(() => {
            alert.style.transition = 'opacity 0.5s';
            alert.style.opacity = '0';
            setTimeout(() => {
                alert.remove();
            }, 500);
        }, 5000);
    });
});

// Form validation
document.addEventListener('DOMContentLoaded', function() {
    const forms = document.querySelectorAll('form');
    
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const requiredInputs = form.querySelectorAll('[required]');
            let isValid = true;
            
            requiredInputs.forEach(input => {
                if (!input.value.trim()) {
                    isValid = false;
                    input.style.borderColor = '#f44336';
                } else {
                    input.style.borderColor = '#ddd';
                }
            });
            
            if (!isValid) {
                e.preventDefault();
                alert('لطفاً تمام فیلدهای الزامی را پر کنید.');
            }
        });
    });
});

// Mobile responsive table scroll hint
document.addEventListener('DOMContentLoaded', function() {
    const tables = document.querySelectorAll('.table-responsive');
    
    tables.forEach(table => {
        if (table.scrollWidth > table.clientWidth) {
            table.style.cursor = 'grab';
            
            let isDown = false;
            let startX;
            let scrollLeft;
            
            table.addEventListener('mousedown', (e) => {
                isDown = true;
                startX = e.pageX - table.offsetLeft;
                scrollLeft = table.scrollLeft;
                table.style.cursor = 'grabbing';
            });
            
            table.addEventListener('mouseleave', () => {
                isDown = false;
                table.style.cursor = 'grab';
            });
            
            table.addEventListener('mouseup', () => {
                isDown = false;
                table.style.cursor = 'grab';
            });
            
            table.addEventListener('mousemove', (e) => {
                if (!isDown) return;
                e.preventDefault();
                const x = e.pageX - table.offsetLeft;
                const walk = (x - startX) * 2;
                table.scrollLeft = scrollLeft - walk;
            });
        }
    });
});

// Smooth scroll
document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
            target.scrollIntoView({
                behavior: 'smooth',
                block: 'start'
            });
        }
    });
});

// Add loading state to buttons
document.addEventListener('DOMContentLoaded', function() {
    const forms = document.querySelectorAll('form');
    
    forms.forEach(form => {
        form.addEventListener('submit', function() {
            const submitBtn = form.querySelector('button[type="submit"]');
            if (submitBtn) {
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال پردازش...';
            }
        });
    });
});

// Countries Modal Functions
function showCountriesModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) {
        modal.style.display = 'block';
        document.body.style.overflow = 'hidden'; // Prevent background scroll
    }
}

function closeCountriesModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) {
        modal.style.display = 'none';
        document.body.style.overflow = ''; // Restore scroll
    }
}

// Close modal when clicking outside
document.addEventListener('DOMContentLoaded', function() {
    const modals = document.querySelectorAll('.countries-modal');
    
    modals.forEach(modal => {
        modal.addEventListener('click', function(e) {
            if (e.target === modal) {
                closeCountriesModal(modal.id);
            }
        });
    });
    
    // Close modal on Escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            modals.forEach(modal => {
                if (modal.style.display === 'block') {
                    closeCountriesModal(modal.id);
                }
            });
        }
    });
});

