<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../api/esim-api.php';

requireAdmin();

$pageTitle = 'کنسل دستی eSIM';
$success = '';
$error = '';
$result = null;

// Handle cancel by esimTranNo
if (isset($_POST['cancel_by_tran_no'])) {
    $esimTranNo = trim($_POST['esim_tran_no'] ?? '');
    
    if ($esimTranNo) {
        try {
            $api = new eSIMAPI();
            $result = $api->cancelESIM($esimTranNo);
            
            if ($result && isset($result['success']) && $result['success'] === true) {
                $success = "✅ eSIM با موفقیت کنسل شد! (esimTranNo: $esimTranNo)";
            } else {
                $errorMsg = $result['errorMsg'] ?? 'خطای ناشناخته';
                $error = "❌ خطا در کنسل کردن: $errorMsg";
            }
        } catch (Exception $e) {
            $error = '❌ خطا: ' . $e->getMessage();
        }
    } else {
        $error = '⚠️ لطفاً esimTranNo را وارد کنید';
    }
}

// Handle query all eSIMs
if (isset($_POST['query_all'])) {
    try {
        $api = new eSIMAPI();
        $result = $api->queryESIMByOrderNo(''); // Empty orderNo to get all
        
        if ($result && isset($result['success']) && $result['success'] === true) {
            $success = "✅ لیست eSIM ها دریافت شد";
        } else {
            $error = "❌ خطا در دریافت لیست";
        }
    } catch (Exception $e) {
        $error = '❌ خطا: ' . $e->getMessage();
    }
}

include __DIR__ . '/../includes/header.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');

body, h1, h2, h3, h4, h5, h6, p, span, div, a, button, input, textarea, select, label, td, th {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
}

.fas, .far, .fab, .fa {
    font-family: "Font Awesome 6 Free", "Font Awesome 6 Brands" !important;
}


.admin-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 30px;
}

.page-header {
    background: white;
    border-radius: 12px;
    padding: 30px;
    margin-bottom: 30px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
}

.page-header h1 {
    color: #667eea;
    margin: 0;
}

.section {
    background: white;
    border-radius: 12px;
    padding: 30px;
    margin-bottom: 30px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
}

.section h2 {
    color: #667eea;
    margin-bottom: 20px;
}

.alert {
    padding: 15px;
    border-radius: 8px;
    margin-bottom: 20px;
}

.alert-success {
    background: #d4edda;
    border: 1px solid #c3e6cb;
    color: #155724;
}

.alert-error {
    background: #f8d7da;
    border: 1px solid #f5c6cb;
    color: #721c24;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #333;
}

.form-group input {
    width: 100%;
    padding: 12px;
    border: 1px solid #ddd;
    border-radius: 8px;
    font-size: 14px;
}

.form-group small {
    display: block;
    margin-top: 5px;
    color: #666;
}

.btn {
    display: inline-block;
    padding: 12px 30px;
    background: #667eea;
    color: white;
    text-decoration: none;
    border-radius: 8px;
    border: none;
    cursor: pointer;
    font-size: 16px;
    transition: background 0.3s;
}

.btn:hover {
    background: #5568d3;
}

.btn-danger {
    background: #dc3545;
}

.btn-danger:hover {
    background: #c82333;
}

.btn-success {
    background: #28a745;
}

.btn-success:hover {
    background: #218838;
}

.response-box {
    background: #2d3748;
    color: #68d391;
    padding: 20px;
    border-radius: 8px;
    font-family: monospace;
    overflow-x: auto;
    white-space: pre-wrap;
    word-wrap: break-word;
    margin-top: 20px;
}

.esim-list {
    margin-top: 20px;
}

.esim-item {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    margin-bottom: 10px;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.esim-info {
    flex: 1;
}

.esim-info strong {
    display: block;
    color: #667eea;
    margin-bottom: 5px;
}

.esim-info small {
    color: #666;
    display: block;
}

.badge {
    display: inline-block;
    padding: 5px 12px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
    margin-left: 10px;
}

.badge-success {
    background: #d4edda;
    color: #155724;
}

.badge-error {
    background: #f8d7da;
    color: #721c24;
}

.badge-warning {
    background: #fff3cd;
    color: #856404;
}
</style>

<div class="admin-container">
    <div class="page-header">
        <h1>
            <i class="fas fa-times-circle"></i>
            کنسل دستی eSIM
        </h1>
        <p style="color: #666; margin-top: 10px;">
            برای کنسل کردن eSIM هایی که در پنل API eSIM Access دارید
        </p>
    </div>

    <?php if ($success): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i>
        <?php echo $success; ?>
    </div>
    <?php endif; ?>

    <?php if ($error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i>
        <?php echo $error; ?>
    </div>
    <?php endif; ?>

    <!-- Query All eSIMs -->
    <div class="section">
        <h2>
            <i class="fas fa-list"></i>
            مشاهده تمام eSIM ها
        </h2>
        <p style="color: #666; margin-bottom: 20px;">
            ابتدا لیست تمام eSIM های موجود در پنل API را مشاهده کنید
        </p>
        <form method="POST">
            <button type="submit" name="query_all" class="btn btn-success">
                <i class="fas fa-sync"></i>
                دریافت لیست eSIM ها
            </button>
        </form>

        <?php if ($result && isset($result['obj']['esimList'])): ?>
        <div class="esim-list">
            <h3 style="margin-top: 30px; color: #333;">
                📋 لیست eSIM ها (<?php echo count($result['obj']['esimList']); ?> عدد)
            </h3>
            <?php foreach ($result['obj']['esimList'] as $esim): ?>
            <div class="esim-item">
                <div class="esim-info">
                    <strong>
                        <?php echo htmlspecialchars($esim['packageList'][0]['packageName'] ?? 'N/A'); ?>
                    </strong>
                    <small>
                        <strong>esimTranNo:</strong> <?php echo htmlspecialchars($esim['esimTranNo']); ?> |
                        <strong>ICCID:</strong> <?php echo htmlspecialchars($esim['iccid']); ?> |
                        <strong>Order:</strong> <?php echo htmlspecialchars($esim['orderNo']); ?>
                    </small>
                    <small>
                        <strong>Status:</strong> 
                        <span class="badge badge-<?php echo $esim['esimStatus'] == 'RELEASED' ? 'success' : ($esim['esimStatus'] == 'CANCEL' ? 'error' : 'warning'); ?>">
                            <?php echo htmlspecialchars($esim['esimStatus']); ?>
                        </span>
                    </small>
                </div>
                <?php if ($esim['esimStatus'] != 'CANCEL'): ?>
                <form method="POST" style="display: inline;" onsubmit="return confirm('آیا مطمئن هستید؟');">
                    <input type="hidden" name="esim_tran_no" value="<?php echo htmlspecialchars($esim['esimTranNo']); ?>">
                    <button type="submit" name="cancel_by_tran_no" class="btn btn-danger">
                        <i class="fas fa-times"></i>
                        کنسل
                    </button>
                </form>
                <?php else: ?>
                <span class="badge badge-error">کنسل شده</span>
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>

    <!-- Cancel by esimTranNo -->
    <div class="section">
        <h2>
            <i class="fas fa-times-circle"></i>
            کنسل با esimTranNo
        </h2>
        <p style="color: #666; margin-bottom: 20px;">
            اگر esimTranNo را دارید، می‌توانید مستقیماً کنسل کنید
        </p>
        <form method="POST">
            <div class="form-group">
                <label>esimTranNo:</label>
                <input type="text" 
                       name="esim_tran_no" 
                       placeholder="مثال: 23120118156818"
                       required>
                <small>این شماره را از پنل API eSIM Access یا از لیست بالا کپی کنید</small>
            </div>
            <button type="submit" name="cancel_by_tran_no" class="btn btn-danger">
                <i class="fas fa-times"></i>
                کنسل کردن eSIM
            </button>
        </form>
    </div>

    <?php if ($result): ?>
    <div class="section">
        <h2>
            <i class="fas fa-code"></i>
            پاسخ API
        </h2>
        <div class="response-box">
<?php echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE); ?>
        </div>
    </div>
    <?php endif; ?>

    <div style="text-align: center; margin-top: 30px;">
        <a href="/admin/esims.php" class="btn">
            <i class="fas fa-arrow-left"></i>
            بازگشت به مدیریت eSIM ها
        </a>
    </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>

