<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/api/esim-api.php';

// Get parameters from ZarinPal callback
$authority = $_GET['Authority'] ?? '';
$status = $_GET['Status'] ?? '';

$pageTitle = 'نتیجه پرداخت';

// Find order by authority
$conn = getDBConnection();
$stmt = $conn->prepare("SELECT * FROM orders WHERE payment_authority = ?");
$stmt->bind_param("s", $authority);
$stmt->execute();
$result = $stmt->get_result();
$order = $result->fetch_assoc();
$stmt->close();
$conn->close();

$paymentSuccess = false;
$refId = '';
$error = '';

if (!$order) {
    $error = 'سفارش یافت نشد';
} elseif ($status !== 'OK') {
    $error = 'پرداخت توسط کاربر لغو شد';
    updateOrderStatus($order['id'], 'cancelled');
} else {
    // Verify payment with Iran server
    $verifyData = [
        'action' => 'verify_payment',
        'authority' => $authority,
        'amount' => (int)$order['price_irr']
    ];

    $ch = curl_init(IRAN_SERVER_URL);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($verifyData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode === 200 && $response) {
        $responseData = json_decode($response, true);
        
        if ($responseData && $responseData['status'] === 'success') {
            $refId = $responseData['ref_id'] ?? 'N/A';
            $paymentSuccess = true;
            
            // Update order status
            updateOrderStatus($order['id'], 'paid', ['ref_id' => $refId]);
            
            // Create eSIM via API
            try {
                $api = new eSIMAPI();
                $esimResult = $api->createESIMOrder($order['package_code'], 1);
                
                if ($esimResult && $esimResult['code'] === 0) {
                    $esimData = [
                        'esim_id' => $esimResult['obj']['esimId'] ?? '',
                        'iccid' => $esimResult['obj']['iccid'] ?? '',
                        'qr_code' => $esimResult['obj']['qrCode'] ?? '',
                        'activation_code' => $esimResult['obj']['activationCode'] ?? ''
                    ];
                    
                    updateOrderWithESIM($order['id'], $esimData);
                }
            } catch (Exception $e) {
                // Log error but don't fail the payment
                error_log('eSIM creation failed: ' . $e->getMessage());
            }
        } else {
            $error = $responseData['message'] ?? 'خطا در تایید پرداخت';
            updateOrderStatus($order['id'], 'failed');
        }
    } else {
        $error = 'خطا در اتصال به سرور تایید پرداخت';
        updateOrderStatus($order['id'], 'failed');
    }
}

include __DIR__ . '/includes/header.php';
?>

<style>
.result-container {
    max-width: 600px;
    margin: 50px auto;
    background: white;
    border-radius: 15px;
    padding: 40px;
    box-shadow: 0 5px 25px rgba(0, 0, 0, 0.1);
    text-align: center;
}

.result-icon {
    font-size: 100px;
    margin-bottom: 20px;
}

.result-icon.success {
    color: #28a745;
}

.result-icon.error {
    color: #dc3545;
}

.result-title {
    font-size: 28px;
    margin-bottom: 15px;
}

.result-title.success {
    color: #28a745;
}

.result-title.error {
    color: #dc3545;
}

.result-message {
    color: #666;
    font-size: 16px;
    line-height: 1.8;
    margin: 20px 0;
}

.order-details {
    background: #f8f9fa;
    padding: 25px;
    border-radius: 10px;
    margin: 30px 0;
    text-align: right;
}

.order-details h3 {
    color: #667eea;
    margin-bottom: 20px;
    text-align: center;
}

.detail-row {
    display: flex;
    justify-content: space-between;
    padding: 12px 0;
    border-bottom: 1px solid #e0e0e0;
}

.detail-row:last-child {
    border-bottom: none;
}

.detail-row strong {
    color: #999;
}

.detail-row span {
    color: #333;
    font-weight: 600;
}

.ref-id-box {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 20px;
    border-radius: 10px;
    margin: 20px 0;
}

.ref-id-box .label {
    font-size: 14px;
    opacity: 0.9;
}

.ref-id-box .value {
    font-size: 24px;
    font-weight: bold;
    margin-top: 10px;
}

.btn {
    display: inline-block;
    padding: 14px 35px;
    background: #667eea;
    color: white;
    text-decoration: none;
    border-radius: 8px;
    margin: 10px 5px;
    transition: background 0.3s;
    font-weight: bold;
}

.btn:hover {
    background: #5568d3;
}

.btn-success {
    background: #28a745;
}

.btn-success:hover {
    background: #218838;
}

.error-box {
    background: #fee;
    border: 1px solid #fcc;
    color: #c33;
    padding: 20px;
    border-radius: 8px;
    margin: 20px 0;
}
</style>

<div class="container">
    <div class="result-container">
        <?php if ($paymentSuccess): ?>
            <div class="result-icon success">
                <i class="fas fa-check-circle"></i>
            </div>
            <h1 class="result-title success">پرداخت موفق!</h1>
            <p class="result-message">
                پرداخت شما با موفقیت انجام شد. eSIM شما آماده است و به ایمیل شما ارسال خواهد شد.
            </p>

            <div class="ref-id-box">
                <div class="label">شماره پیگیری پرداخت</div>
                <div class="value"><?php echo htmlspecialchars($refId); ?></div>
            </div>

            <div class="order-details">
                <h3><i class="fas fa-file-invoice"></i> جزئیات سفارش</h3>
                <div class="detail-row">
                    <strong>شماره سفارش:</strong>
                    <span>#<?php echo $order['id']; ?></span>
                </div>
                <div class="detail-row">
                    <strong>بسته:</strong>
                    <span><?php echo htmlspecialchars($order['package_name']); ?></span>
                </div>
                <div class="detail-row">
                    <strong>کشور:</strong>
                    <span><?php echo htmlspecialchars($order['country_name']); ?></span>
                </div>
                <div class="detail-row">
                    <strong>حجم:</strong>
                    <span><?php echo htmlspecialchars($order['data_amount']); ?></span>
                </div>
                <div class="detail-row">
                    <strong>مدت:</strong>
                    <span><?php echo $order['validity_days']; ?> روز</span>
                </div>
                <div class="detail-row">
                    <strong>مبلغ پرداختی:</strong>
                    <span><?php echo formatPrice($order['price_irr']); ?> تومان</span>
                </div>
            </div>

            <div style="margin-top: 30px;">
                <a href="/dashboard.php" class="btn btn-success">
                    <i class="fas fa-list"></i>
                    مشاهده سفارشات من
                </a>
                <a href="/" class="btn">
                    <i class="fas fa-home"></i>
                    بازگشت به خانه
                </a>
            </div>

        <?php else: ?>
            <div class="result-icon error">
                <i class="fas fa-times-circle"></i>
            </div>
            <h1 class="result-title error">پرداخت ناموفق</h1>
            
            <div class="error-box">
                <i class="fas fa-exclamation-triangle"></i>
                <?php echo htmlspecialchars($error); ?>
            </div>

            <p class="result-message">
                متأسفانه پرداخت شما انجام نشد. در صورت کسر مبلغ از حساب، طی 72 ساعت به حساب شما بازگردانده می‌شود.
            </p>

            <?php if ($order): ?>
                <div style="margin-top: 30px;">
                    <a href="/checkout.php?package=<?php echo urlencode($order['package_code']); ?>&country=<?php echo urlencode($order['country_code']); ?>" class="btn btn-success">
                        <i class="fas fa-redo"></i>
                        تلاش مجدد
                    </a>
                    <a href="/" class="btn">
                        <i class="fas fa-home"></i>
                        بازگشت به خانه
                    </a>
                </div>
            <?php else: ?>
                <div style="margin-top: 30px;">
                    <a href="/" class="btn">
                        <i class="fas fa-home"></i>
                        بازگشت به خانه
                    </a>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>

