<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';

// Redirect if already logged in
if (isLoggedIn()) {
    header('Location: /dashboard.php');
    exit;
}

$pageTitle = 'ورود / ثبت نام';
$error = '';
$success = '';
$showRegister = isset($_GET['register']) || isset($_POST['register']);

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
    $mobile = sanitize($_POST['mobile'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($mobile) || empty($password)) {
        $error = 'لطفاً شماره موبایل و رمز عبور را وارد کنید';
    } elseif (!validateMobile($mobile)) {
        $error = 'شماره موبایل نامعتبر است';
    } else {
        if (loginUser($mobile, $password)) {
            header('Location: /dashboard.php');
            exit;
        } else {
            $error = 'شماره موبایل یا رمز عبور اشتباه است';
        }
    }
}

// Handle registration
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['register'])) {
    $mobile = sanitize($_POST['reg_mobile'] ?? '');
    $email = sanitize($_POST['reg_email'] ?? '');
    $password = $_POST['reg_password'] ?? '';
    $confirmPassword = $_POST['reg_confirm_password'] ?? '';
    
    if (empty($mobile) || empty($email) || empty($password) || empty($confirmPassword)) {
        $error = 'لطفاً تمام فیلدها را پر کنید';
        $showRegister = true;
    } elseif (!validateMobile($mobile)) {
        $error = 'شماره موبایل نامعتبر است';
        $showRegister = true;
    } elseif (!validateEmail($email)) {
        $error = 'آدرس ایمیل نامعتبر است';
        $showRegister = true;
    } elseif (strlen($password) < 6) {
        $error = 'رمز عبور باید حداقل 6 کاراکتر باشد';
        $showRegister = true;
    } elseif ($password !== $confirmPassword) {
        $error = 'رمز عبور و تکرار آن مطابقت ندارند';
        $showRegister = true;
    } else {
        if (getUserByMobile($mobile)) {
            $error = 'این شماره موبایل قبلاً ثبت شده است';
            $showRegister = true;
        } else {
            $userId = createUser($mobile, $email, $password);
            if ($userId) {
                loginUser($mobile, $password);
                header('Location: /dashboard.php');
                exit;
            } else {
                $error = 'خطا در ثبت نام. لطفاً دوباره تلاش کنید';
                $showRegister = true;
            }
        }
    }
}

include __DIR__ . '/includes/header.php';
?>

<style>
.auth-container {
    max-width: 500px;
    margin: 50px auto;
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 25px rgba(0, 0, 0, 0.1);
    overflow: hidden;
}

.auth-tabs {
    display: flex;
    background: #f5f5f5;
}

.auth-tab {
    flex: 1;
    padding: 20px;
    text-align: center;
    cursor: pointer;
    font-weight: bold;
    color: #666;
    transition: all 0.3s;
    border: none;
    background: transparent;
}

.auth-tab.active {
    background: white;
    color: #667eea;
}

.auth-content {
    padding: 40px;
}

.auth-form {
    display: none;
}

.auth-form.active {
    display: block;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #333;
}

.form-group input {
    width: 100%;
    padding: 12px 15px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    font-size: 15px;
    transition: border 0.3s;
}

.form-group input:focus {
    outline: none;
    border-color: #667eea;
}

.form-group small {
    display: block;
    margin-top: 5px;
    color: #999;
    font-size: 13px;
}

.alert {
    padding: 15px;
    border-radius: 8px;
    margin-bottom: 20px;
}

.alert-error {
    background: #fee;
    color: #c33;
    border: 1px solid #fcc;
}

.alert-success {
    background: #efe;
    color: #3c3;
    border: 1px solid #cfc;
}

.btn {
    width: 100%;
    padding: 14px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    border-radius: 8px;
    font-size: 16px;
    font-weight: bold;
    cursor: pointer;
    transition: opacity 0.3s;
}

.btn:hover {
    opacity: 0.9;
}

.auth-footer {
    text-align: center;
    margin-top: 20px;
    color: #666;
}

.auth-footer a {
    color: #667eea;
    text-decoration: none;
    font-weight: bold;
}
</style>

<div class="container">
    <div class="auth-container">
        <div class="auth-tabs">
            <button class="auth-tab <?php echo !$showRegister ? 'active' : ''; ?>" onclick="showLogin()">
                <i class="fas fa-sign-in-alt"></i> ورود
            </button>
            <button class="auth-tab <?php echo $showRegister ? 'active' : ''; ?>" onclick="showRegister()">
                <i class="fas fa-user-plus"></i> ثبت نام
            </button>
        </div>

        <div class="auth-content">
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i>
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>

            <?php if ($success): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <?php echo $success; ?>
                </div>
            <?php endif; ?>

            <!-- Login Form -->
            <form method="POST" class="auth-form <?php echo !$showRegister ? 'active' : ''; ?>" id="loginForm">
                <div class="form-group">
                    <label>
                        <i class="fas fa-mobile-alt"></i>
                        شماره موبایل
                    </label>
                    <input type="text" name="mobile" required placeholder="09123456789" 
                           value="<?php echo htmlspecialchars($_POST['mobile'] ?? ''); ?>">
                </div>

                <div class="form-group">
                    <label>
                        <i class="fas fa-lock"></i>
                        رمز عبور
                    </label>
                    <input type="password" name="password" required placeholder="رمز عبور خود را وارد کنید">
                </div>

                <button type="submit" name="login" class="btn">
                    <i class="fas fa-sign-in-alt"></i>
                    ورود به حساب کاربری
                </button>

                <div class="auth-footer">
                    حساب کاربری ندارید؟
                    <a href="#" onclick="showRegister(); return false;">ثبت نام کنید</a>
                </div>
            </form>

            <!-- Register Form -->
            <form method="POST" class="auth-form <?php echo $showRegister ? 'active' : ''; ?>" id="registerForm">
                <div class="form-group">
                    <label>
                        <i class="fas fa-mobile-alt"></i>
                        شماره موبایل
                    </label>
                    <input type="text" name="reg_mobile" required placeholder="09123456789"
                           value="<?php echo htmlspecialchars($_POST['reg_mobile'] ?? ''); ?>">
                    <small>این شماره برای ورود به حساب کاربری استفاده می‌شود</small>
                </div>

                <div class="form-group">
                    <label>
                        <i class="fas fa-envelope"></i>
                        آدرس ایمیل
                    </label>
                    <input type="email" name="reg_email" required placeholder="example@email.com"
                           value="<?php echo htmlspecialchars($_POST['reg_email'] ?? ''); ?>">
                    <small>eSIM به این ایمیل ارسال می‌شود</small>
                </div>

                <div class="form-group">
                    <label>
                        <i class="fas fa-lock"></i>
                        رمز عبور
                    </label>
                    <input type="password" name="reg_password" required placeholder="حداقل 6 کاراکتر">
                    <small>رمز عبور باید حداقل 6 کاراکتر باشد</small>
                </div>

                <div class="form-group">
                    <label>
                        <i class="fas fa-lock"></i>
                        تکرار رمز عبور
                    </label>
                    <input type="password" name="reg_confirm_password" required placeholder="رمز عبور را مجدداً وارد کنید">
                </div>

                <button type="submit" name="register" class="btn">
                    <i class="fas fa-user-plus"></i>
                    ثبت نام و ایجاد حساب
                </button>

                <div class="auth-footer">
                    قبلاً ثبت نام کرده‌اید؟
                    <a href="#" onclick="showLogin(); return false;">وارد شوید</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function showLogin() {
    document.getElementById('loginForm').classList.add('active');
    document.getElementById('registerForm').classList.remove('active');
    
    document.querySelectorAll('.auth-tab')[0].classList.add('active');
    document.querySelectorAll('.auth-tab')[1].classList.remove('active');
}

function showRegister() {
    document.getElementById('loginForm').classList.remove('active');
    document.getElementById('registerForm').classList.add('active');
    
    document.querySelectorAll('.auth-tab')[0].classList.remove('active');
    document.querySelectorAll('.auth-tab')[1].classList.add('active');
}
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>

