<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';

requireLogin();

// Get eSIM ID from URL
$esimId = isset($_GET['id']) ? intval($_GET['id']) : 0;

if (!$esimId) {
    header('Location: /my-esims.php');
    exit;
}

// Get eSIM from database
$conn = getDBConnection();
$stmt = $conn->prepare("SELECT * FROM orders WHERE id = ? AND user_id = ? AND status = 'paid'");
$stmt->bind_param("ii", $esimId, $_SESSION['user_id']);
$stmt->execute();
$result = $stmt->get_result();
$esim = $result->fetch_assoc();
$stmt->close();
$conn->close();

if (!$esim) {
    header('Location: /my-esims.php');
    exit;
}

$pageTitle = 'خرید بسته جدید';
include __DIR__ . '/includes/header.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');

body, h1, h2, h3, h4, h5, h6, p, span, div, a, button, input, textarea, select, label {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
}

.fas, .far, .fab, .fa {
    font-family: "Font Awesome 6 Free", "Font Awesome 6 Brands" !important;
}

.container {
    max-width: 900px;
    margin: 0 auto;
    padding: 30px 20px;
}

.info-box {
    background: linear-gradient(135deg, #CB1919 0%, #FF2929 100%);
    color: white;
    padding: 40px;
    border-radius: 20px;
    text-align: center;
    margin-bottom: 30px;
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
}

.info-box h1 {
    font-size: 2.5rem;
    font-weight: 900;
    margin-bottom: 15px;
}

.info-box p {
    font-size: 1.2rem;
    opacity: 0.95;
    line-height: 1.8;
}

.current-esim {
    background: white;
    padding: 30px;
    border-radius: 15px;
    margin-bottom: 30px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.current-esim h2 {
    color: #1e293b;
    font-size: 1.5rem;
    font-weight: 800;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.current-esim h2 i {
    color: #CB1919;
}

.esim-details {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.detail-item {
    background: #f8fafc;
    padding: 20px;
    border-radius: 12px;
    border: 2px solid #e2e8f0;
}

.detail-item .label {
    color: #64748b;
    font-size: 0.9rem;
    font-weight: 600;
    margin-bottom: 8px;
}

.detail-item .value {
    color: #1e293b;
    font-size: 1.1rem;
    font-weight: 800;
}

.alert-info {
    background: #e0e7ff;
    border: 2px solid #c7d2fe;
    color: #3730a3;
    padding: 25px;
    border-radius: 15px;
    margin-bottom: 30px;
    display: flex;
    align-items: flex-start;
    gap: 15px;
}

.alert-info i {
    font-size: 2rem;
    margin-top: 5px;
}

.alert-info div {
    flex: 1;
}

.alert-info h3 {
    font-size: 1.3rem;
    font-weight: 800;
    margin-bottom: 10px;
}

.alert-info p {
    line-height: 1.8;
    margin: 8px 0;
}

.alert-warning {
    background: #fef3c7;
    border: 2px solid #fbbf24;
    color: #92400e;
    padding: 25px;
    border-radius: 15px;
    margin-bottom: 30px;
}

.alert-warning h3 {
    font-weight: 800;
    margin-bottom: 10px;
}

.options-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 25px;
    margin-bottom: 30px;
}

.option-card {
    background: white;
    border: 3px solid #e2e8f0;
    border-radius: 15px;
    padding: 30px;
    text-align: center;
    transition: all 0.3s ease;
    cursor: pointer;
}

.option-card:hover {
    border-color: #CB1919;
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.2);
}

.option-card .icon {
    font-size: 4rem;
    margin-bottom: 20px;
}

.option-card.recommended {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    border-color: #10b981;
}

.option-card.recommended .icon {
    color: white;
}

.option-card h3 {
    font-size: 1.5rem;
    font-weight: 800;
    margin-bottom: 15px;
}

.option-card p {
    line-height: 1.8;
    margin-bottom: 25px;
}

.btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    padding: 15px 35px;
    border: none;
    border-radius: 12px;
    font-size: 1.1rem;
    font-weight: 800;
    cursor: pointer;
    transition: all 0.3s ease;
    text-decoration: none;
}

.btn-primary {
    background: linear-gradient(135deg, #CB1919 0%, #FF2929 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
}

.btn-success {
    background: white;
    color: #059669;
    border: 2px solid white;
}

.btn-success:hover {
    background: rgba(255,255,255,0.9);
}

.btn-secondary {
    background: #e2e8f0;
    color: #475569;
}

.btn-secondary:hover {
    background: #cbd5e1;
}

@media (max-width: 768px) {
    .info-box h1 {
        font-size: 1.8rem;
    }
    
    .options-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="container">
    <div class="info-box">
        <h1>
            <i class="fas fa-shopping-cart"></i>
            خرید بسته جدید
        </h1>
        <p>برای افزایش حجم اینترنت، یک بسته جدید خریداری کنید</p>
    </div>
    
    <div class="current-esim">
        <h2>
            <i class="fas fa-sim-card"></i>
            eSIM فعلی شما
        </h2>
        
        <div class="esim-details">
            <div class="detail-item">
                <div class="label">کشور</div>
                <div class="value"><?php echo htmlspecialchars($esim['country_name'] ?? 'نامشخص'); ?></div>
            </div>
            <div class="detail-item">
                <div class="label">بسته</div>
                <div class="value"><?php echo htmlspecialchars($esim['package_name'] ?? 'نامشخص'); ?></div>
            </div>
            <div class="detail-item">
                <div class="label">ICCID</div>
                <div class="value" style="font-size:0.9rem;"><?php echo substr($esim['iccid'], 0, 10) . '...'; ?></div>
            </div>
        </div>
    </div>
    
    <div class="alert-info">
        <i class="fas fa-info-circle"></i>
        <div>
            <h3>چگونه حجم اضافه کنیم؟</h3>
            <p><strong>راه حل پیشنهادی:</strong> خرید یک eSIM جدید برای همان کشور</p>
            <p>شما می‌توانید چندین eSIM برای یک کشور داشته باشید و بین آنها جابجا شوید.</p>
            <p>هر eSIM مستقل عمل می‌کند و حجم و مدت زمان خاص خود را دارد.</p>
        </div>
    </div>
    
    <div class="options-grid">
        <div class="option-card recommended">
            <div class="icon">
                <i class="fas fa-plus-circle"></i>
            </div>
            <h3>خرید eSIM جدید</h3>
            <p>یک بسته جدید برای <?php echo htmlspecialchars($esim['country_name'] ?? 'این کشور'); ?> خریداری کنید</p>
            <a href="/country.php?code=<?php echo htmlspecialchars($esim['country_code']); ?>" class="btn btn-success">
                <i class="fas fa-shopping-bag"></i>
                مشاهده بسته‌ها
            </a>
        </div>
        
        <div class="option-card">
            <div class="icon" style="color: #CB1919;">
                <i class="fas fa-globe"></i>
            </div>
            <h3>کشور دیگر</h3>
            <p>برای سفر به کشور دیگری eSIM خریداری کنید</p>
            <a href="/" class="btn btn-primary">
                <i class="fas fa-search"></i>
                انتخاب کشور
            </a>
        </div>
    </div>
    
    <div class="alert-warning">
        <h3>
            <i class="fas fa-exclamation-triangle"></i>
            چرا نمی‌توان به eSIM فعلی حجم اضافه کرد؟
        </h3>
        <p>متأسفانه API ارائه‌دهنده eSIM ما در حال حاضر از قابلیت "شارژ مجدد" (Topup) پشتیبانی نمی‌کند.</p>
        <p>به همین دلیل، برای افزایش حجم، باید یک eSIM جدید خریداری کنید.</p>
    </div>
    
    <div style="text-align: center; margin-top: 30px;">
        <a href="/my-esims.php" class="btn btn-secondary">
            <i class="fas fa-arrow-right"></i>
            بازگشت به eSIM های من
        </a>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>

