<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';

$error = '';
$success = '';

if (isLoggedIn()) {
    header('Location: /dashboard.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = sanitize($_POST['name'] ?? '');
    $mobile = sanitize($_POST['mobile'] ?? '');
    $email = sanitize($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';
    
    if (empty($mobile) || empty($password)) {
        $error = 'لطفاً تمام فیلدهای الزامی را پر کنید.';
    } elseif (!validateMobile($mobile)) {
        $error = 'شماره موبایل نامعتبر است.';
    } elseif (!empty($email) && !validateEmail($email)) {
        $error = 'ایمیل نامعتبر است.';
    } elseif (strlen($password) < 6) {
        $error = 'رمز عبور باید حداقل 6 کاراکتر باشد.';
    } elseif ($password !== $confirm_password) {
        $error = 'رمز عبور و تکرار آن یکسان نیستند.';
    } else {
        // Check if user already exists
        if (getUserByMobile($mobile)) {
            $error = 'این شماره موبایل قبلاً ثبت شده است.';
        } else {
            $userId = createUser($mobile, $email, $password, $name);
            
            if ($userId) {
                // Auto login
                $_SESSION['user_id'] = $userId;
                $_SESSION['mobile'] = $mobile;
                $_SESSION['email'] = $email;
                $_SESSION['name'] = $name;
                $_SESSION['is_admin'] = 0;
                
                $redirect = $_GET['redirect'] ?? '/dashboard.php';
                header('Location: ' . $redirect);
                exit;
            } else {
                $error = 'خطا در ثبت‌نام. لطفاً دوباره تلاش کنید.';
            }
        }
    }
}

$pageTitle = 'ثبت‌نام';
include __DIR__ . '/includes/header.php';
?>

<style>
.auth-container {
    max-width: 500px;
    margin: 3rem auto;
    padding: 0 1rem;
}

.auth-box {
    background: white;
    border-radius: 20px;
    padding: 2.5rem;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
}

.auth-header {
    text-align: center;
    margin-bottom: 2rem;
}

.auth-header i {
    font-size: 4rem;
    background: linear-gradient(135deg, #CB1919 0%, #FF2929 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    margin-bottom: 1rem;
}

.auth-header h2 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
}

.auth-header p {
    color: #7f8c8d;
    font-size: 0.95rem;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: 600;
    color: #333;
}

.form-group label .required {
    color: #e74c3c;
}

.form-group input {
    width: 100%;
    padding: 15px;
    border: 2px solid #e0e0e0;
    border-radius: 10px;
    font-size: 1rem;
    box-sizing: border-box;
    font-family: 'Vazirmatn', Arial, sans-serif;
    transition: border-color 0.3s;
}

.form-group input:focus {
    outline: none;
    border-color: #CB1919;
}

.form-group small {
    color: #666;
    font-size: 0.85rem;
    display: block;
    margin-top: 5px;
}

.btn {
    padding: 15px 30px;
    border: none;
    border-radius: 10px;
    font-size: 1.1rem;
    font-weight: 600;
    cursor: pointer;
    width: 100%;
    font-family: 'Vazirmatn', Arial, sans-serif;
    transition: all 0.3s;
}

.btn-primary {
    background: linear-gradient(135deg, #CB1919 0%, #FF2929 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
}

.auth-footer {
    text-align: center;
    margin-top: 2rem;
    padding-top: 2rem;
    border-top: 1px solid #e0e0e0;
}

.auth-footer p {
    color: #7f8c8d;
    margin: 0;
}

.auth-footer a {
    color: #CB1919;
    text-decoration: none;
    font-weight: 600;
}

.auth-footer a:hover {
    text-decoration: underline;
}

.alert {
    padding: 15px 20px;
    border-radius: 10px;
    margin-bottom: 20px;
}

.alert-error {
    background: #fee;
    color: #c33;
    border: 1px solid #fcc;
}

.alert-success {
    background: #efe;
    color: #3c3;
    border: 1px solid #cfc;
}
</style>

<div class="auth-container">
    <div class="auth-box">
        <?php if ($error): ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i>
            <?php echo $error; ?>
        </div>
        <?php endif; ?>

        <?php if ($success): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <?php echo $success; ?>
        </div>
        <?php endif; ?>

        <div class="auth-header">
            <i class="fas fa-user-plus"></i>
            <h2>ثبت‌نام</h2>
            <p>برای ایجاد حساب کاربری فرم را پر کنید</p>
        </div>

        <form method="POST" class="auth-form">
            <div class="form-group">
                <label>نام (اختیاری)</label>
                <input type="text" name="name" placeholder="نام شما" 
                       value="<?php echo htmlspecialchars($_POST['name'] ?? ''); ?>">
                <small>می‌توانید به فارسی یا انگلیسی بنویسید</small>
            </div>

            <div class="form-group">
                <label>شماره موبایل <span class="required">*</span></label>
                <input type="text" name="mobile" placeholder="۰۹۱۲۳۴۵۶۷۸۹" required 
                       value="<?php echo htmlspecialchars($_POST['mobile'] ?? ''); ?>"
                       style="text-align: center;">
                <small>می‌توانید با اعداد فارسی یا انگلیسی بنویسید</small>
            </div>

            <div class="form-group">
                <label>ایمیل (اختیاری)</label>
                <input type="email" name="email" placeholder="example@email.com"
                       value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>">
            </div>

            <div class="form-group">
                <label>رمز عبور <span class="required">*</span></label>
                <input type="password" name="password" placeholder="حداقل 6 کاراکتر" required>
                <small>حداقل 6 کاراکتر</small>
            </div>

            <div class="form-group">
                <label>تکرار رمز عبور <span class="required">*</span></label>
                <input type="password" name="confirm_password" placeholder="تکرار رمز عبور" required>
            </div>

            <button type="submit" class="btn btn-primary">
                ثبت‌نام
                <i class="fas fa-user-check"></i>
            </button>
        </form>

        <div class="auth-footer">
            <p>قبلاً ثبت‌نام کرده‌اید؟ <a href="/login.php">وارد شوید</a></p>
        </div>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>
