<?php
require_once __DIR__ . '/config/config.php';

echo "<h1>Install OTP Database</h1>";

$conn = getDBConnection();

// Create OTP table
$sql = "CREATE TABLE IF NOT EXISTS otps (
    id INT AUTO_INCREMENT PRIMARY KEY,
    phone VARCHAR(32) NOT NULL,
    otp_hash VARCHAR(128) NOT NULL,
    created_at DATETIME NOT NULL,
    expires_at DATETIME NOT NULL,
    used TINYINT(1) DEFAULT 0,
    attempts INT DEFAULT 0,
    INDEX idx_phone (phone),
    INDEX idx_expires (expires_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

if ($conn->query($sql)) {
    echo "<p style='color: green;'>✅ Table 'otps' created successfully!</p>";
} else {
    echo "<p style='color: red;'>❌ Error creating table: " . $conn->error . "</p>";
}

// Create rate limit table
$sql2 = "CREATE TABLE IF NOT EXISTS otp_rate_limits (
    id INT AUTO_INCREMENT PRIMARY KEY,
    phone VARCHAR(32) NOT NULL,
    ip_address VARCHAR(45) NOT NULL,
    action VARCHAR(20) NOT NULL,
    attempts INT DEFAULT 1,
    blocked_until DATETIME NULL,
    created_at DATETIME NOT NULL,
    INDEX idx_phone_action (phone, action),
    INDEX idx_ip (ip_address)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4";

if ($conn->query($sql2)) {
    echo "<p style='color: green;'>✅ Table 'otp_rate_limits' created successfully!</p>";
} else {
    echo "<p style='color: red;'>❌ Error creating table: " . $conn->error . "</p>";
}

// Add OTP settings
$conn->query("INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('ippanel_api_key', 'yscjWq9-KctIRCU7OC3HBejG4PRa5KyjcHzcFVjPy_g=')");
$conn->query("INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('ippanel_pattern_code', 'v43ncjmlxcwaczv')");
$conn->query("INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('ippanel_sender', '+985000125475')");
$conn->query("INSERT IGNORE INTO settings (setting_key, setting_value) VALUES ('otp_secret', '" . bin2hex(random_bytes(32)) . "')");

echo "<p style='color: green;'>✅ OTP settings added!</p>";

$conn->close();

echo "<h2>Done!</h2>";
echo "<p><a href='checkout.php?package=CKH031&country=AE'>Test Checkout with OTP</a></p>";
?>

<style>
body {
    font-family: Tahoma, Arial, sans-serif;
    padding: 20px;
    direction: rtl;
}
h1, h2 {
    color: #333;
}
</style>
