<?php
/**
 * Session Configuration - باید اول از همه include بشه
 * این فایل تنظیمات session رو درست می‌کنه قبل از session_start()
 */

// فقط یکبار اجرا بشه
if (defined('SESSION_CONFIG_LOADED')) {
    return;
}
define('SESSION_CONFIG_LOADED', true);

// Session Configuration - CRITICAL!
ini_set('session.save_handler', 'files');
ini_set('session.use_cookies', 1);
ini_set('session.use_only_cookies', 1);
ini_set('session.cookie_httponly', 0); // باید 0 باشه تا JavaScript بتونه cookie بخونه
ini_set('session.cookie_samesite', 'Lax');
ini_set('session.use_strict_mode', 1);
ini_set('session.cookie_lifetime', 30 * 24 * 60 * 60); // 30 days
ini_set('session.gc_maxlifetime', 30 * 24 * 60 * 60); // 30 days

// تنظیم path برای session files
$session_path = ini_get('session.save_path');
if (empty($session_path) || !is_writable($session_path)) {
    $custom_session_path = __DIR__ . '/../tmp/sessions';
    if (!file_exists($custom_session_path)) {
        @mkdir($custom_session_path, 0777, true);
    }
    if (is_writable($custom_session_path)) {
        ini_set('session.save_path', $custom_session_path);
    }
}

// Set session cookie parameters
session_set_cookie_params([
    'lifetime' => 30 * 24 * 60 * 60, // 30 days
    'path' => '/',
    'domain' => '', // خالی = current domain
    'secure' => false, // false = works on both HTTP and HTTPS
    'httponly' => false, // false = JavaScript can read it
    'samesite' => 'Lax'
]);

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Debug: Log session info
if (isset($_GET['debug_session'])) {
    error_log('Session ID: ' . session_id());
    error_log('Session Status: ' . session_status());
    error_log('Session Save Path: ' . session_save_path());
    error_log('Session Data: ' . print_r($_SESSION, true));
}

