<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

echo "<h1>Step 1: PHP is working ✓</h1>";

// Test config
echo "<h2>Step 2: Loading config...</h2>";
try {
    require_once __DIR__ . '/config/config.php';
    echo "✓ Config loaded successfully<br>";
} catch (Exception $e) {
    echo "✗ Config error: " . $e->getMessage() . "<br>";
    die();
}

// Test database
echo "<h2>Step 3: Testing database...</h2>";
try {
    $conn = getDBConnection();
    echo "✓ Database connected successfully<br>";
    $conn->close();
} catch (Exception $e) {
    echo "✗ Database error: " . $e->getMessage() . "<br>";
    die();
}

// Test functions
echo "<h2>Step 4: Loading functions...</h2>";
try {
    require_once __DIR__ . '/includes/functions.php';
    echo "✓ Functions loaded successfully<br>";
} catch (Exception $e) {
    echo "✗ Functions error: " . $e->getMessage() . "<br>";
    die();
}

// Test session
echo "<h2>Step 5: Testing session...</h2>";
if (session_status() === PHP_SESSION_ACTIVE) {
    echo "✓ Session is active<br>";
} else {
    echo "✗ Session is not active<br>";
}

// Test login status
echo "<h2>Step 6: Testing login...</h2>";
if (isLoggedIn()) {
    echo "✓ User is logged in<br>";
    echo "User ID: " . ($_SESSION['user_id'] ?? 'N/A') . "<br>";
    echo "Mobile: " . ($_SESSION['mobile'] ?? 'N/A') . "<br>";
} else {
    echo "✗ User is not logged in<br>";
    echo "<a href='/login.php'>Click here to login</a><br>";
}

// Test getUserOrders function
if (isLoggedIn()) {
    echo "<h2>Step 7: Testing getUserOrders...</h2>";
    try {
        $orders = getUserOrders($_SESSION['user_id']);
        echo "✓ getUserOrders executed successfully<br>";
        echo "Total orders: " . count($orders) . "<br>";
        
        $paidOrders = getUserOrders($_SESSION['user_id'], 'paid');
        echo "Paid orders: " . count($paidOrders) . "<br>";
    } catch (Exception $e) {
        echo "✗ getUserOrders error: " . $e->getMessage() . "<br>";
        echo "Error trace: <pre>" . $e->getTraceAsString() . "</pre>";
    }
}

echo "<h2>✅ All tests passed!</h2>";
echo "<p><a href='/my-esims.php'>Try my-esims.php now</a></p>";
?>

