<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/api/esim-api.php';

echo "<h1>🔍 API Debug Test</h1>";
echo "<hr>";

// Test 1: Check API configuration
echo "<h2>⚙️ API Configuration:</h2>";
echo "<ul>";
echo "<li><strong>API URL:</strong> " . ESIM_API_URL . "</li>";
echo "<li><strong>Access Code:</strong> " . ESIM_ACCESS_CODE . "</li>";
echo "<li><strong>Security Key:</strong> " . substr(ESIM_SECURITY_KEY, 0, 10) . "..." . "</li>";
echo "</ul>";

echo "<hr>";

// Test 2: Try to get all packages (simpler API call)
echo "<h2>📦 Test 1: Get All Packages</h2>";
$api = new eSIMAPI();
$packagesResponse = $api->getAllPackages();

echo "<h3>Response:</h3>";
echo "<pre style='background: #f5f5f5; padding: 15px; border-radius: 8px; overflow-x: auto;'>";
print_r($packagesResponse);
echo "</pre>";

if ($packagesResponse && isset($packagesResponse['code']) && $packagesResponse['code'] == 0) {
    echo "<p style='color: green; font-weight: bold;'>✅ API Connection Working!</p>";
} else {
    echo "<p style='color: red; font-weight: bold;'>❌ API Connection Failed!</p>";
}

echo "<hr>";

// Test 3: Check database for orders with ICCID
echo "<h2>💾 Test 2: Check Database Orders</h2>";
$conn = getDBConnection();
$result = $conn->query("SELECT id, user_id, package_name, iccid, status, created_at FROM orders ORDER BY id DESC LIMIT 5");

if ($result && $result->num_rows > 0) {
    echo "<table border='1' cellpadding='10' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>ID</th><th>User ID</th><th>Package</th><th>ICCID</th><th>Status</th><th>Created</th></tr>";
    
    $testIccid = null;
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . $row['user_id'] . "</td>";
        echo "<td>" . htmlspecialchars($row['package_name']) . "</td>";
        echo "<td style='font-family: monospace;'>" . htmlspecialchars($row['iccid'] ?? 'N/A') . "</td>";
        echo "<td>" . $row['status'] . "</td>";
        echo "<td>" . $row['created_at'] . "</td>";
        echo "</tr>";
        
        if (!$testIccid && !empty($row['iccid'])) {
            $testIccid = $row['iccid'];
        }
    }
    echo "</table>";
    
    // Test 4: If we have ICCID, test queryProfile
    if ($testIccid) {
        echo "<hr>";
        echo "<h2>🧪 Test 3: Query Profile with ICCID</h2>";
        echo "<p><strong>Testing ICCID:</strong> <code>" . htmlspecialchars($testIccid) . "</code></p>";
        
        $profileResponse = $api->queryProfile($testIccid);
        
        echo "<h3>Response:</h3>";
        echo "<pre style='background: #f5f5f5; padding: 15px; border-radius: 8px; overflow-x: auto;'>";
        print_r($profileResponse);
        echo "</pre>";
        
        if ($profileResponse === false) {
            echo "<p style='color: red; font-weight: bold;'>❌ API returned FALSE (connection error or HTTP error)</p>";
        } elseif ($profileResponse && isset($profileResponse['code'])) {
            if ($profileResponse['code'] == 0) {
                echo "<p style='color: green; font-weight: bold;'>✅ API Call Successful!</p>";
                
                if (isset($profileResponse['obj']['esimList'])) {
                    echo "<p><strong>Number of eSIMs found:</strong> " . count($profileResponse['obj']['esimList']) . "</p>";
                } else {
                    echo "<p style='color: orange;'>⚠️ No esimList in response</p>";
                }
            } else {
                echo "<p style='color: red; font-weight: bold;'>❌ API Error!</p>";
                echo "<p><strong>Error Code:</strong> " . $profileResponse['code'] . "</p>";
                echo "<p><strong>Error Message:</strong> " . ($profileResponse['msg'] ?? 'N/A') . "</p>";
            }
        } else {
            echo "<p style='color: red; font-weight: bold;'>❌ Invalid API Response</p>";
        }
    } else {
        echo "<hr>";
        echo "<p style='color: orange; font-weight: bold;'>⚠️ No ICCID found in database to test</p>";
    }
} else {
    echo "<p style='color: red; font-weight: bold;'>❌ No orders found in database</p>";
}

echo "<hr>";

// Test 5: Check PHP cURL
echo "<h2>🔧 Test 4: PHP Environment</h2>";
echo "<ul>";
echo "<li><strong>PHP Version:</strong> " . phpversion() . "</li>";
echo "<li><strong>cURL Enabled:</strong> " . (function_exists('curl_init') ? '✅ Yes' : '❌ No') . "</li>";
echo "<li><strong>OpenSSL Enabled:</strong> " . (extension_loaded('openssl') ? '✅ Yes' : '❌ No') . "</li>";
echo "<li><strong>JSON Enabled:</strong> " . (function_exists('json_encode') ? '✅ Yes' : '❌ No') . "</li>";
echo "</ul>";

$conn->close();
?>

