<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/api/esim-api.php';

echo "<h1>🔍 بررسی سفارش و لاگ‌ها</h1>";
echo "<style>
body{font-family:Tahoma;padding:20px;direction:rtl;line-height:2;background:#f5f5f5;} 
.success{color:green;font-weight:bold;} 
.error{color:red;font-weight:bold;} 
.info{color:blue;font-weight:bold;} 
.warning{color:orange;font-weight:bold;}
pre{background:#fff;padding:15px;border-radius:8px;direction:ltr;overflow-x:auto;border:1px solid #ddd;font-size:12px;max-height:400px;}
.box{background:white;padding:20px;margin:20px 0;border-radius:10px;box-shadow:0 2px 10px rgba(0,0,0,0.1);}
table{width:100%;border-collapse:collapse;margin:15px 0;}
table th{background:#667eea;color:white;padding:12px;text-align:right;}
table td{padding:10px;border:1px solid #ddd;word-break:break-all;}
table tr:nth-child(even){background:#f9f9f9;}
.btn{background:#667eea;color:white;padding:12px 25px;border:none;border-radius:8px;cursor:pointer;font-weight:bold;text-decoration:none;display:inline-block;margin:10px 5px;}
.btn:hover{background:#5568d3;}
.btn-success{background:#10b981;}
.btn-success:hover{background:#059669;}
</style>";

$conn = getDBConnection();

// Get latest paid order
$stmt = $conn->prepare("SELECT * FROM orders WHERE status = 'paid' ORDER BY created_at DESC LIMIT 1");
$stmt->execute();
$result = $stmt->get_result();
$order = $result->fetch_assoc();
$stmt->close();

if (!$order) {
    echo "<div class='box'>";
    echo "<p class='error'>❌ هیچ سفارش پرداخت شده‌ای پیدا نشد</p>";
    echo "</div>";
    $conn->close();
    exit;
}

echo "<div class='box'>";
echo "<h2>📦 آخرین سفارش پرداخت شده</h2>";
echo "<table>";
echo "<tr><th>فیلد</th><th>مقدار</th></tr>";
echo "<tr><td>شناسه سفارش</td><td><strong>#{$order['id']}</strong></td></tr>";
echo "<tr><td>بسته</td><td>{$order['package_name']}</td></tr>";
echo "<tr><td>کد بسته</td><td><code>{$order['package_code']}</code></td></tr>";
echo "<tr><td>کشور</td><td>{$order['country_name']} ({$order['country_code']})</td></tr>";
echo "<tr><td>مبلغ (تومان)</td><td>" . number_format($order['price_irr']) . "</td></tr>";
echo "<tr><td>مبلغ (دلار)</td><td>\${$order['price_usd']}</td></tr>";
echo "<tr><td>وضعیت</td><td><span class='success'>{$order['status']}</span></td></tr>";
echo "<tr><td>تاریخ</td><td>{$order['created_at']}</td></tr>";
echo "<tr><td>Authority</td><td>" . ($order['payment_authority'] ?? 'ندارد') . "</td></tr>";
echo "<tr><td>Ref ID</td><td>" . ($order['payment_ref_id'] ?? 'ندارد') . "</td></tr>";
echo "<tr><td><strong>ICCID</strong></td><td><strong>" . ($order['iccid'] ?? '<span class="error">❌ ندارد</span>') . "</strong></td></tr>";
echo "<tr><td><strong>QR Code</strong></td><td>" . ($order['qr_code'] ?? '<span class="error">❌ ندارد</span>') . "</td></tr>";
echo "<tr><td><strong>Activation Code</strong></td><td>" . ($order['activation_code'] ?? '<span class="error">❌ ندارد</span>') . "</td></tr>";
echo "<tr><td><strong>eSIM Tran No</strong></td><td>" . ($order['esim_tran_no'] ?? '<span class="error">❌ ندارد</span>') . "</td></tr>";
echo "</table>";
echo "</div>";

// Check if eSIM data is missing
if (empty($order['iccid']) || empty($order['qr_code'])) {
    echo "<div class='box'>";
    echo "<h2>⚠️ eSIM ساخته نشده!</h2>";
    echo "<p class='warning'>اطلاعات eSIM در دیتابیس وجود ندارد. احتمالاً خطایی در فراخوانی API رخ داده است.</p>";
    
    // Try to create eSIM now
    echo "<h3>🔄 تلاش برای ساخت eSIM...</h3>";
    
    try {
        $api = new eSIMAPI();
        
        echo "<p class='info'>📤 دریافت قیمت جدید از API...</p>";
        
        // Get current package price from API
        $packageData = $api->getPackageByCode($order['package_code']);
        
        if ($packageData && isset($packageData['price'])) {
            $currentPrice = $packageData['price']; // Already in cents
            echo "<p class='success'>✅ قیمت جدید از API: <strong>{$currentPrice} cents</strong></p>";
        } else {
            $currentPrice = round($order['price_usd'] * 100);
            echo "<p class='warning'>⚠️ استفاده از قیمت ذخیره شده: <strong>{$currentPrice} cents</strong></p>";
        }
        
        echo "<p class='info'>📤 ارسال درخواست ساخت eSIM...</p>";
        echo "<p>بسته: <code>{$order['package_code']}</code></p>";
        echo "<p>قیمت: <code>{$currentPrice} cents</code></p>";
        
        $esimResult = $api->createESIMOrder($order['package_code'], 1, $currentPrice);
        
        echo "<h4>📥 پاسخ API:</h4>";
        echo "<pre>" . json_encode($esimResult, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
        
        if ($esimResult && isset($esimResult['success']) && $esimResult['success'] === true) {
            $orderNo = $esimResult['obj']['orderNo'] ?? null;
            
            if ($orderNo) {
                echo "<p class='success'>✅ سفارش در API ساخته شد! Order No: <strong>$orderNo</strong></p>";
                echo "<p class='info'>⏳ صبر 3 ثانیه برای تخصیص eSIM...</p>";
                
                sleep(3);
                
                echo "<p class='info'>🔍 دریافت اطلاعات eSIM...</p>";
                $queryResult = $api->queryESIMByOrderNo($orderNo);
                
                echo "<h4>📥 پاسخ Query:</h4>";
                echo "<pre>" . json_encode($queryResult, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
                
                if ($queryResult && isset($queryResult['success']) && $queryResult['success'] === true) {
                    $esimList = $queryResult['obj']['esimList'] ?? [];
                    
                    if (!empty($esimList)) {
                        $esim = $esimList[0];
                        
                        $iccid = $esim['iccid'] ?? '';
                        $qrCode = $esim['qrCodeUrl'] ?? '';
                        $activationCode = $esim['ac'] ?? '';
                        $esimTranNo = $esim['esimTranNo'] ?? '';
                        
                        echo "<p class='success'>✅ eSIM پیدا شد!</p>";
                        echo "<p><strong>ICCID:</strong> <code>$iccid</code></p>";
                        echo "<p><strong>esimTranNo:</strong> <code>$esimTranNo</code></p>";
                        
                        // Update database
                        $stmt = $conn->prepare("UPDATE orders SET iccid = ?, qr_code = ?, activation_code = ?, esim_tran_no = ? WHERE id = ?");
                        $stmt->bind_param("ssssi", $iccid, $qrCode, $activationCode, $esimTranNo, $order['id']);
                        
                        if ($stmt->execute()) {
                            echo "<p class='success'>✅ دیتابیس به‌روز شد!</p>";
                            echo "<div style='margin-top:20px;'>";
                            echo "<a href='/esim-details.php?id={$order['id']}' class='btn btn-success'>مشاهده جزئیات eSIM</a>";
                            echo "<a href='/my-esims.php' class='btn'>لیست eSIM ها</a>";
                            echo "</div>";
                        } else {
                            echo "<p class='error'>❌ خطا در به‌روزرسانی دیتابیس: " . $stmt->error . "</p>";
                        }
                        $stmt->close();
                        
                    } else {
                        echo "<p class='error'>❌ لیست eSIM خالی است</p>";
                    }
                } else {
                    $errorCode = $queryResult['errorCode'] ?? 'نامشخص';
                    $errorMsg = $queryResult['errorMsg'] ?? 'نامشخص';
                    echo "<p class='error'>❌ خطا در Query: $errorCode - $errorMsg</p>";
                }
            } else {
                echo "<p class='error'>❌ Order No در پاسخ API یافت نشد</p>";
            }
        } else {
            $errorCode = $esimResult['errorCode'] ?? 'نامشخص';
            $errorMsg = $esimResult['errorMsg'] ?? 'نامشخص';
            echo "<p class='error'>❌ خطا در ساخت سفارش: $errorCode - $errorMsg</p>";
        }
        
    } catch (Exception $e) {
        echo "<p class='error'>❌ Exception: " . $e->getMessage() . "</p>";
    }
    
    echo "</div>";
} else {
    echo "<div class='box'>";
    echo "<h2>✅ eSIM موجود است</h2>";
    echo "<p class='success'>اطلاعات eSIM در دیتابیس ذخیره شده است.</p>";
    
    if (!empty($order['qr_code'])) {
        echo "<h3>📱 QR Code:</h3>";
        echo "<img src='{$order['qr_code']}' alt='QR Code' style='max-width:300px;border:2px solid #ddd;border-radius:8px;'>";
    }
    
    echo "<div style='margin-top:20px;'>";
    echo "<a href='/esim-details.php?id={$order['id']}' class='btn btn-success'>مشاهده جزئیات eSIM</a>";
    echo "<a href='/my-esims.php' class='btn'>لیست eSIM ها</a>";
    echo "</div>";
    
    echo "</div>";
}

// Show error log (last 50 lines)
echo "<div class='box'>";
echo "<h2>📋 آخرین لاگ‌های PHP</h2>";
echo "<p class='info'>آخرین 50 خط از error_log:</p>";

$logFile = ini_get('error_log');
if ($logFile && file_exists($logFile)) {
    $lines = file($logFile);
    $lastLines = array_slice($lines, -50);
    echo "<pre>" . htmlspecialchars(implode('', $lastLines)) . "</pre>";
} else {
    echo "<p class='warning'>فایل لاگ پیدا نشد یا مسیر تنظیم نشده</p>";
    echo "<p>مسیر فعلی: <code>" . ($logFile ?: 'تنظیم نشده') . "</code></p>";
}

echo "</div>";

$conn->close();

echo "<hr>";
echo "<p style='text-align:center;'><a href='/dashboard.php' class='btn'>بازگشت به داشبورد</a></p>";
?>

