<?php
require_once __DIR__ . '/config/config.php';

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['install'])) {
    try {
        initializeDatabase();
        $message = 'دیتابیس با موفقیت نصب شد!';
    } catch (Exception $e) {
        $error = 'خطا در نصب: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نصب سیستم eSIM</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .install-container {
            max-width: 600px;
            width: 100%;
            background: white;
            border-radius: 15px;
            padding: 40px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
        }
        
        h1 {
            color: #667eea;
            text-align: center;
            margin-bottom: 30px;
            font-size: 32px;
        }
        
        .info-box {
            background: #e7f3ff;
            border: 2px solid #667eea;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 25px;
        }
        
        .info-box h3 {
            color: #667eea;
            margin-bottom: 15px;
        }
        
        .info-box ul {
            margin-right: 20px;
            line-height: 2;
            color: #666;
        }
        
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: opacity 0.3s;
        }
        
        .btn:hover {
            opacity: 0.9;
        }
        
        .btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        
        .links {
            text-align: center;
            margin-top: 20px;
        }
        
        .links a {
            color: #667eea;
            text-decoration: none;
            margin: 0 10px;
            font-weight: bold;
        }
        
        .links a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="install-container">
        <h1>🚀 نصب سیستم eSIM</h1>

        <?php if ($message): ?>
            <div class="alert alert-success">
                ✅ <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <?php if ($error): ?>
            <div class="alert alert-error">
                ❌ <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <?php if (!$message): ?>
            <div class="info-box">
                <h3>📋 اطلاعات نصب</h3>
                <ul>
                    <li>دیتابیس: <?php echo DB_NAME; ?></li>
                    <li>کاربر: <?php echo DB_USER; ?></li>
                    <li>سرور: <?php echo DB_HOST; ?></li>
                </ul>
            </div>

            <div class="info-box">
                <h3>🔧 عملیات نصب</h3>
                <ul>
                    <li>ایجاد جداول دیتابیس</li>
                    <li>تنظیمات اولیه سیستم</li>
                    <li>ایجاد حساب مدیر (09123456789 / admin123)</li>
                    <li>تنظیم نرخ تبدیل ارز</li>
                    <li>پیکربندی زرین‌پال</li>
                </ul>
            </div>

            <form method="POST">
                <button type="submit" name="install" class="btn">
                    شروع نصب
                </button>
            </form>
        <?php else: ?>
            <div class="info-box">
                <h3>✅ نصب با موفقیت انجام شد!</h3>
                <ul>
                    <li>حساب مدیر: 09123456789</li>
                    <li>رمز عبور: admin123</li>
                    <li>نرخ دلار: 650,000 تومان</li>
                    <li>زرین‌پال: فعال</li>
                </ul>
            </div>

            <div class="links">
                <a href="/">← رفتن به صفحه اصلی</a>
                <a href="/login.php">ورود به سیستم →</a>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>

