<?php
/**
 * تعمیر eSIM های قدیمی - اضافه کردن esim_tran_no
 * این فایل رو یکبار اجرا کنید تا esim_tran_no برای eSIM های قدیمی از API گرفته بشه
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(300); // 5 دقیقه

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/api/esim-api.php';

echo "<!DOCTYPE html><html dir='rtl'><head><meta charset='UTF-8'><title>تعمیر eSIM های قدیمی</title>";
echo "<style>
body{font-family:Tahoma;padding:30px;background:#f5f7fa;line-height:1.8;} 
.box{background:white;padding:20px;border-radius:10px;margin-bottom:15px;box-shadow:0 2px 10px rgba(0,0,0,0.1);} 
.success{color:green;font-weight:bold;} 
.error{color:red;} 
.warning{color:orange;} 
.info{color:blue;} 
code{background:#f0f0f0;padding:3px 8px;border-radius:5px;direction:ltr;display:inline-block;}
table{width:100%;border-collapse:collapse;margin-top:15px;}
th,td{padding:10px;border:1px solid #ddd;text-align:right;}
th{background:#667eea;color:white;}
tr:nth-child(even){background:#f9f9f9;}
.btn{display:inline-block;background:linear-gradient(135deg,#667eea,#764ba2);color:white;padding:12px 25px;border-radius:8px;text-decoration:none;font-weight:bold;margin:10px 5px;}
.btn:hover{opacity:0.9;}
.btn-danger{background:linear-gradient(135deg,#dc3545,#c82333);}
</style>";
echo "</head><body>";

echo "<h1>🔧 تعمیر eSIM های قدیمی</h1>";

$conn = getDBConnection();
$api = new eSIMAPI();

// پیدا کردن eSIM هایی که esim_tran_no ندارن
$query = "SELECT id, iccid, esim_id, esim_tran_no, package_name, created_at 
          FROM orders 
          WHERE status = 'paid' 
          AND iccid IS NOT NULL 
          AND iccid != ''
          AND (esim_tran_no IS NULL OR esim_tran_no = '')
          ORDER BY created_at DESC";

$result = $conn->query($query);
$needsFix = [];
while ($row = $result->fetch_assoc()) {
    $needsFix[] = $row;
}

echo "<div class='box'>";
echo "<h2>📊 وضعیت فعلی</h2>";

// آمار کلی
$totalQuery = $conn->query("SELECT COUNT(*) as total FROM orders WHERE status = 'paid' AND iccid IS NOT NULL AND iccid != ''");
$total = $totalQuery->fetch_assoc()['total'];

$withTranNo = $conn->query("SELECT COUNT(*) as cnt FROM orders WHERE status = 'paid' AND iccid IS NOT NULL AND esim_tran_no IS NOT NULL AND esim_tran_no != ''");
$withTranNoCount = $withTranNo->fetch_assoc()['cnt'];

echo "<p>کل eSIM های پرداخت شده: <strong>$total</strong></p>";
echo "<p>دارای esim_tran_no: <strong class='success'>$withTranNoCount</strong></p>";
echo "<p>بدون esim_tran_no (نیاز به تعمیر): <strong class='warning'>" . count($needsFix) . "</strong></p>";
echo "</div>";

// اگر درخواست تعمیر داده شده
if (isset($_POST['fix_all']) || isset($_GET['fix'])) {
    echo "<div class='box'>";
    echo "<h2>🔄 در حال تعمیر...</h2>";
    
    $fixed = 0;
    $failed = 0;
    $results = [];
    
    foreach ($needsFix as $esim) {
        echo "<p>چک کردن سفارش #{$esim['id']} - ICCID: <code>" . substr($esim['iccid'], 0, 20) . "...</code> ... ";
        flush();
        
        try {
            // گرفتن اطلاعات از API
            $apiResponse = $api->queryProfile($esim['iccid']);
            
            if ($apiResponse && isset($apiResponse['obj']['esimList'][0])) {
                $esimData = $apiResponse['obj']['esimList'][0];
                $esimTranNo = $esimData['esimTranNo'] ?? '';
                
                if (!empty($esimTranNo)) {
                    // آپدیت دیتابیس
                    $stmt = $conn->prepare("UPDATE orders SET esim_tran_no = ?, esim_id = ? WHERE id = ?");
                    $stmt->bind_param("ssi", $esimTranNo, $esimTranNo, $esim['id']);
                    
                    if ($stmt->execute()) {
                        echo "<span class='success'>✅ تعمیر شد! esimTranNo: $esimTranNo</span>";
                        $fixed++;
                        $results[] = ['id' => $esim['id'], 'status' => 'success', 'tran_no' => $esimTranNo];
                    } else {
                        echo "<span class='error'>❌ خطا در ذخیره</span>";
                        $failed++;
                        $results[] = ['id' => $esim['id'], 'status' => 'db_error'];
                    }
                    $stmt->close();
                } else {
                    echo "<span class='warning'>⚠️ esimTranNo در API یافت نشد</span>";
                    $failed++;
                    $results[] = ['id' => $esim['id'], 'status' => 'no_tran_no'];
                }
            } else {
                echo "<span class='error'>❌ پاسخ API نامعتبر</span>";
                $failed++;
                $results[] = ['id' => $esim['id'], 'status' => 'api_error'];
            }
        } catch (Exception $e) {
            echo "<span class='error'>❌ خطا: " . $e->getMessage() . "</span>";
            $failed++;
            $results[] = ['id' => $esim['id'], 'status' => 'exception', 'error' => $e->getMessage()];
        }
        
        echo "</p>";
        
        // تاخیر برای جلوگیری از rate limiting
        usleep(300000); // 0.3 ثانیه
    }
    
    echo "<hr>";
    echo "<h3>📊 نتیجه نهایی:</h3>";
    echo "<p class='success'>✅ تعمیر شده: $fixed</p>";
    echo "<p class='error'>❌ ناموفق: $failed</p>";
    echo "</div>";
}

// نمایش لیست eSIM هایی که نیاز به تعمیر دارن
if (count($needsFix) > 0 && !isset($_POST['fix_all']) && !isset($_GET['fix'])) {
    echo "<div class='box'>";
    echo "<h2>📋 eSIM هایی که نیاز به تعمیر دارند</h2>";
    
    echo "<table>";
    echo "<tr><th>سفارش</th><th>بسته</th><th>ICCID</th><th>esim_id فعلی</th><th>تاریخ</th></tr>";
    
    foreach ($needsFix as $esim) {
        echo "<tr>";
        echo "<td>#{$esim['id']}</td>";
        echo "<td>" . htmlspecialchars($esim['package_name'] ?? '-') . "</td>";
        echo "<td><code>" . substr($esim['iccid'], 0, 20) . "...</code></td>";
        echo "<td>" . htmlspecialchars($esim['esim_id'] ?? '-') . "</td>";
        echo "<td>" . date('Y/m/d', strtotime($esim['created_at'])) . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
    echo "<form method='POST' style='margin-top:20px;'>";
    echo "<button type='submit' name='fix_all' class='btn' onclick=\"return confirm('آیا مطمئنید؟ این عملیات ممکنه چند دقیقه طول بکشه.');\">🔧 تعمیر همه (" . count($needsFix) . " مورد)</button>";
    echo "</form>";
    
    echo "<p style='margin-top:15px;color:#666;'>یا از طریق URL:</p>";
    echo "<code>https://esim.matinacard.com/fix-old-esims.php?fix=1</code>";
    
    echo "</div>";
} elseif (count($needsFix) == 0 && !isset($_POST['fix_all']) && !isset($_GET['fix'])) {
    echo "<div class='box' style='background:linear-gradient(135deg,#28a745,#20c997);color:white;'>";
    echo "<h2>✅ همه چیز درسته!</h2>";
    echo "<p>همه eSIM ها دارای esim_tran_no هستند.</p>";
    echo "</div>";
}

// لینک‌های مفید
echo "<div class='box'>";
echo "<h2>🔗 لینک‌های مفید</h2>";
echo "<a href='/setup-usage-alerts.php' class='btn'>نصب سیستم اعلان</a>";
echo "<a href='/cron-check-usage.php?key=esim_cron_2024_secret' class='btn'>تست اعلان مصرف</a>";
echo "<a href='/admin/esims.php' class='btn'>مدیریت eSIM ها</a>";
echo "<a href='/sync-iccids.php' class='btn'>Sync ICCIDs</a>";
echo "</div>";

$conn->close();

echo "</body></html>";
?>

