<?php
/**
 * فایل Debug برای بررسی پاسخ API
 * این فایل نشون میده که API دقیقاً چه داده‌هایی برمی‌گردونه
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/api/esim-api.php';

// بررسی لاگین
if (!isLoggedIn()) {
    die('لطفاً ابتدا وارد شوید');
}

// ICCID از URL یا آخرین eSIM کاربر
$iccid = $_GET['iccid'] ?? '';

if (empty($iccid)) {
    // گرفتن آخرین eSIM کاربر
    $conn = getDBConnection();
    $stmt = $conn->prepare("SELECT iccid FROM orders WHERE user_id = ? AND status = 'paid' AND iccid IS NOT NULL ORDER BY created_at DESC LIMIT 1");
    $stmt->bind_param("i", $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $stmt->close();
    $conn->close();
    
    if ($row) {
        $iccid = $row['iccid'];
    }
}

if (empty($iccid)) {
    die('هیچ eSIM پیدا نشد. ICCID را در URL وارد کنید: ?iccid=YOUR_ICCID');
}

echo "<html dir='rtl'><head><meta charset='UTF-8'><title>Debug eSIM API</title>";
echo "<style>
body { font-family: Tahoma, sans-serif; padding: 20px; background: #f5f5f5; }
.box { background: white; padding: 20px; border-radius: 10px; margin-bottom: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
h2 { color: #CB1919; border-bottom: 2px solid #CB1919; padding-bottom: 10px; }
pre { background: #1e293b; color: #10b981; padding: 15px; border-radius: 8px; overflow-x: auto; direction: ltr; text-align: left; }
.success { color: #10b981; }
.error { color: #ef4444; }
.warning { color: #f59e0b; }
table { width: 100%; border-collapse: collapse; }
th, td { padding: 10px; border: 1px solid #e2e8f0; text-align: right; }
th { background: #f8fafc; }
</style></head><body>";

echo "<h1>🔍 Debug eSIM API Response</h1>";

// اطلاعات ICCID
echo "<div class='box'>";
echo "<h2>📋 اطلاعات ICCID</h2>";
echo "<p><strong>ICCID:</strong> <code>{$iccid}</code></p>";
echo "</div>";

// ساخت API و درخواست
$api = new eSIMAPI();

echo "<div class='box'>";
echo "<h2>🌐 پاسخ خام API (queryProfile)</h2>";

$apiResponse = $api->queryProfile($iccid);

if ($apiResponse) {
    echo "<p class='success'>✅ درخواست API موفق بود</p>";
    echo "<pre>" . json_encode($apiResponse, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
} else {
    echo "<p class='error'>❌ خطا در درخواست API</p>";
}
echo "</div>";

// تحلیل داده‌ها
if ($apiResponse) {
    echo "<div class='box'>";
    echo "<h2>📊 تحلیل داده‌ها</h2>";
    
    // بررسی کد موفقیت
    $isSuccess = false;
    if (isset($apiResponse['code']) && $apiResponse['code'] == 0) {
        $isSuccess = true;
        echo "<p class='success'>✅ code = 0 (موفق)</p>";
    } elseif (isset($apiResponse['success']) && $apiResponse['success'] === true) {
        $isSuccess = true;
        echo "<p class='success'>✅ success = true</p>";
    } elseif (isset($apiResponse['errorCode']) && $apiResponse['errorCode'] === '0') {
        $isSuccess = true;
        echo "<p class='success'>✅ errorCode = 0</p>";
    } else {
        echo "<p class='error'>❌ پاسخ ناموفق یا ساختار ناشناخته</p>";
    }
    
    // پیدا کردن لیست eSIM
    echo "<h3>🔍 جستجوی esimList</h3>";
    
    $esimList = null;
    $esimData = null;
    
    // روش 1: obj.esimList
    if (isset($apiResponse['obj']['esimList'])) {
        $esimList = $apiResponse['obj']['esimList'];
        echo "<p class='success'>✅ پیدا شد در: obj.esimList</p>";
    }
    // روش 2: obj (مستقیم)
    elseif (isset($apiResponse['obj']) && is_array($apiResponse['obj'])) {
        $esimList = $apiResponse['obj'];
        echo "<p class='warning'>⚠️ پیدا شد در: obj (مستقیم)</p>";
    }
    // روش 3: data.esimList
    elseif (isset($apiResponse['data']['esimList'])) {
        $esimList = $apiResponse['data']['esimList'];
        echo "<p class='success'>✅ پیدا شد در: data.esimList</p>";
    }
    // روش 4: esimList (ریشه)
    elseif (isset($apiResponse['esimList'])) {
        $esimList = $apiResponse['esimList'];
        echo "<p class='success'>✅ پیدا شد در: esimList (ریشه)</p>";
    }
    else {
        echo "<p class='error'>❌ esimList پیدا نشد!</p>";
    }
    
    if ($esimList && is_array($esimList) && !empty($esimList)) {
        // اگه آرایه‌ای از eSIM هاست
        if (isset($esimList[0]) && is_array($esimList[0])) {
            $esimData = $esimList[0];
            echo "<p class='success'>✅ اولین آیتم از آرایه انتخاب شد</p>";
        } else {
            $esimData = $esimList;
            echo "<p class='warning'>⚠️ خود آرایه به عنوان eSIM Data استفاده شد</p>";
        }
    }
    
    echo "</div>";
    
    // نمایش فیلدهای eSIM
    if ($esimData) {
        echo "<div class='box'>";
        echo "<h2>📦 فیلدهای eSIM</h2>";
        echo "<table>";
        echo "<tr><th>فیلد</th><th>مقدار</th><th>توضیح</th></tr>";
        
        $fields = [
            'esimStatus' => 'وضعیت eSIM',
            'iccid' => 'ICCID',
            'totalVolume' => 'حجم کل (بایت)',
            'orderUsage' => 'مصرف شده (بایت)',
            'totalDuration' => 'مدت اعتبار (روز)',
            'expiredTime' => 'تاریخ انقضا',
            'activateTime' => 'زمان فعال‌سازی',
            'apn' => 'APN / شبکه',
            'ipExport' => 'IP Export',
            'smdpStatus' => 'وضعیت SMDP',
            'packageName' => 'نام بسته',
            'esimTranNo' => 'شماره تراکنش eSIM',
            'orderNo' => 'شماره سفارش',
        ];
        
        foreach ($fields as $field => $label) {
            $value = $esimData[$field] ?? '<span class="warning">ندارد</span>';
            
            // تبدیل حجم به GB
            if (($field == 'totalVolume' || $field == 'orderUsage') && is_numeric($value)) {
                $valueGB = round($value / 1024 / 1024 / 1024, 2);
                $value = "{$value} ({$valueGB} GB)";
            }
            
            echo "<tr><td><code>{$field}</code></td><td>{$value}</td><td>{$label}</td></tr>";
        }
        
        echo "</table>";
        
        // نمایش همه فیلدهای موجود
        echo "<h3>📋 همه فیلدهای موجود:</h3>";
        echo "<pre>" . json_encode($esimData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
        
        echo "</div>";
        
        // بررسی وضعیت
        echo "<div class='box'>";
        echo "<h2>🔎 بررسی وضعیت</h2>";
        
        $status = $esimData['esimStatus'] ?? 'نامشخص';
        $statusMap = [
            'GOT_RESOURCE' => '⏳ آماده نصب',
            'RELEASED' => '⏳ آماده نصب',
            'INSTALLED' => '📲 نصب شده',
            'ACTIVATED' => '✅ فعال شده',
            'ACTIVE' => '🟢 فعال',
            'IN_USE' => '🌐 در حال استفاده',
            'DEPLETED' => '⚠️ حجم تمام شده',
            'EXPIRED' => '❌ منقضی شده',
            'CANCEL' => '🚫 لغو شده'
        ];
        
        $statusText = $statusMap[$status] ?? "⚪ نامشخص ({$status})";
        echo "<p><strong>وضعیت فعلی:</strong> {$statusText}</p>";
        
        // بررسی حجم
        if (isset($esimData['totalVolume']) && isset($esimData['orderUsage'])) {
            $total = $esimData['totalVolume'];
            $used = $esimData['orderUsage'];
            $remaining = $total - $used;
            $percentage = $total > 0 ? round(($used / $total) * 100, 1) : 0;
            
            echo "<p><strong>حجم کل:</strong> " . round($total / 1024 / 1024 / 1024, 2) . " GB</p>";
            echo "<p><strong>مصرف شده:</strong> " . round($used / 1024 / 1024 / 1024, 2) . " GB ({$percentage}%)</p>";
            echo "<p><strong>باقیمانده:</strong> " . round($remaining / 1024 / 1024 / 1024, 2) . " GB</p>";
        } else {
            echo "<p class='warning'>⚠️ اطلاعات حجم موجود نیست</p>";
            echo "<p>فیلدهای موجود برای حجم:</p>";
            echo "<ul>";
            foreach ($esimData as $key => $val) {
                if (stripos($key, 'volume') !== false || stripos($key, 'usage') !== false || stripos($key, 'data') !== false) {
                    echo "<li><code>{$key}</code>: {$val}</li>";
                }
            }
            echo "</ul>";
        }
        
        echo "</div>";
    }
}

echo "<div class='box'>";
echo "<h2>🔧 راهنمای رفع مشکل</h2>";
echo "<p>اگر وضعیت نشون میده «آماده نصب» اما eSIM واقعاً فعاله:</p>";
echo "<ol>";
echo "<li>بررسی کنید <code>esimStatus</code> چی برمی‌گردونه</li>";
echo "<li>ممکنه API با تاخیر آپدیت بشه - چند دقیقه صبر کنید</li>";
echo "<li>فیلدهای <code>totalVolume</code> و <code>orderUsage</code> رو چک کنید</li>";
echo "</ol>";
echo "</div>";

echo "</body></html>";

