<?php
/**
 * سیستم خودکار چک مصرف eSIM
 * این فایل رو به footer یا هر صفحه‌ای که ترافیک داره include کنید
 * بدون نیاز به Cron Job کار می‌کنه!
 */

// تنظیمات
define('CHECK_INTERVAL_HOURS', 1); // هر چند ساعت یکبار چک بشه
define('LAST_CHECK_FILE', __DIR__ . '/logs/last-usage-check.txt');

/**
 * چک کردن اینکه آیا زمان اجرای بعدی رسیده یا نه
 */
function shouldRunUsageCheck() {
    $logDir = dirname(LAST_CHECK_FILE);
    if (!is_dir($logDir)) {
        @mkdir($logDir, 0755, true);
    }
    
    // اگر فایل وجود نداره، باید اجرا بشه
    if (!file_exists(LAST_CHECK_FILE)) {
        return true;
    }
    
    // چک کردن آخرین زمان اجرا
    $lastCheck = (int) @file_get_contents(LAST_CHECK_FILE);
    $hoursSinceLastCheck = (time() - $lastCheck) / 3600;
    
    return $hoursSinceLastCheck >= CHECK_INTERVAL_HOURS;
}

/**
 * ذخیره زمان آخرین اجرا
 */
function markUsageCheckDone() {
    @file_put_contents(LAST_CHECK_FILE, time());
}

/**
 * اجرای چک مصرف در پس‌زمینه (بدون تاخیر برای کاربر)
 */
function runUsageCheckAsync() {
    // ذخیره زمان فعلی قبل از اجرا
    markUsageCheckDone();
    
    // اجرا در پس‌زمینه با curl
    $url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http");
    $url .= "://" . $_SERVER['HTTP_HOST'] . "/cron-check-usage.php?key=esim_cron_2024_secret&async=1";
    
    // اجرای غیرهمزمان - کاربر منتظر نمیمونه
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 1); // فقط 1 ثانیه صبر کن
    curl_setopt($ch, CURLOPT_NOSIGNAL, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    @curl_exec($ch);
    curl_close($ch);
}

// اجرای خودکار
if (shouldRunUsageCheck()) {
    runUsageCheckAsync();
}

