<?php
/**
 * صفحه تست SMS برای eSIM
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../api/esim-api.php';

requireAdmin();

$result = null;
$error = '';

// تست ارسال SMS
if (isset($_POST['test_sms'])) {
    $esimTranNo = $_POST['esim_tran_no'] ?? '';
    $message = $_POST['message'] ?? '';
    
    if ($esimTranNo && $message) {
        try {
            $api = new eSIMAPI();
            $result = $api->sendSMS($esimTranNo, $message);
            
        } catch (Exception $e) {
            $error = 'خطا: ' . $e->getMessage();
        }
    } else {
        $error = 'لطفاً همه فیلدها را پر کنید';
    }
}

// گرفتن لیست eSIM ها برای انتخاب
$conn = getDBConnection();
$query = "SELECT id, mobile, esim_id, esim_tran_no, iccid, package_name 
          FROM orders 
          WHERE status = 'paid' AND iccid IS NOT NULL 
          ORDER BY created_at DESC 
          LIMIT 20";
$esimResult = $conn->query($query);
$esims = [];
while ($row = $esimResult->fetch_assoc()) {
    $esims[] = $row;
}
$conn->close();

?>
<!DOCTYPE html>
<html dir="rtl" lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تست SMS eSIM</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Vazirmatn', Tahoma, Arial, sans-serif;
        }
        
        body {
            background: #f5f7fa;
            padding: 30px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
        }
        
        h1 {
            color: #333;
            margin-bottom: 30px;
        }
        
        .card {
            background: white;
            border-radius: 15px;
            padding: 25px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
        }
        
        input, select, textarea {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 15px;
            transition: border-color 0.3s;
        }
        
        input:focus, select:focus, textarea:focus {
            outline: none;
            border-color: #667eea;
        }
        
        .btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.3s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .result {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-top: 20px;
        }
        
        .result.success {
            background: #d4edda;
            border: 1px solid #c3e6cb;
        }
        
        .result.error {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
        }
        
        pre {
            background: #263238;
            color: #80CBC4;
            padding: 15px;
            border-radius: 8px;
            overflow-x: auto;
            direction: ltr;
            text-align: left;
            font-size: 13px;
        }
        
        .back-link {
            display: inline-block;
            margin-bottom: 20px;
            color: #667eea;
            text-decoration: none;
        }
        
        .back-link:hover {
            text-decoration: underline;
        }
        
        .info-box {
            background: #e8f4fd;
            border: 1px solid #b8daff;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
            color: #004085;
        }
        
        .info-box i {
            margin-left: 8px;
        }
        
        .esim-option {
            padding: 10px;
            background: #f0f0f0;
            margin: 5px 0;
            border-radius: 5px;
            font-size: 13px;
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="/admin/esims.php" class="back-link">
            <i class="fas fa-arrow-right"></i>
            بازگشت به مدیریت eSIM ها
        </a>
        
        <h1><i class="fas fa-sms"></i> تست ارسال SMS به eSIM</h1>
        
        <div class="info-box">
            <i class="fas fa-info-circle"></i>
            <strong>توجه:</strong> این قابلیت برای ارسال پیامک مستقیم به سیم‌کارت eSIM از طریق API است.
            <br>
            برای کار کردن این قابلیت، باید <code>esimTranNo</code> صحیح باشد.
        </div>
        
        <div class="card">
            <form method="POST">
                <div class="form-group">
                    <label>انتخاب eSIM:</label>
                    <select name="esim_tran_no" required onchange="updateSelectedInfo(this)">
                        <option value="">-- انتخاب کنید --</option>
                        <?php foreach ($esims as $esim): ?>
                            <?php 
                            $tranNo = $esim['esim_tran_no'] ?? $esim['esim_id'] ?? '';
                            if (empty($tranNo)) continue;
                            ?>
                            <option value="<?php echo htmlspecialchars($tranNo); ?>"
                                    data-mobile="<?php echo htmlspecialchars($esim['mobile']); ?>"
                                    data-iccid="<?php echo htmlspecialchars($esim['iccid']); ?>">
                                سفارش #<?php echo $esim['id']; ?> - 
                                <?php echo htmlspecialchars($esim['package_name']); ?> - 
                                موبایل: <?php echo htmlspecialchars($esim['mobile']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div id="selectedInfo" class="esim-option" style="display:none;"></div>
                
                <div class="form-group">
                    <label>یا وارد کردن دستی esimTranNo:</label>
                    <input type="text" name="manual_tran_no" placeholder="مثال: 123456789" 
                           onchange="document.querySelector('[name=esim_tran_no]').value = this.value">
                </div>
                
                <div class="form-group">
                    <label>متن پیام:</label>
                    <textarea name="message" rows="4" required placeholder="متن پیامک خود را وارد کنید...">سلام! این یک پیام تست است.</textarea>
                    <small style="color:#666;">حداکثر 160 کاراکتر</small>
                </div>
                
                <button type="submit" name="test_sms" class="btn">
                    <i class="fas fa-paper-plane"></i>
                    ارسال پیامک
                </button>
            </form>
            
            <?php if ($error): ?>
            <div class="result error">
                <strong>❌ خطا:</strong> <?php echo htmlspecialchars($error); ?>
            </div>
            <?php endif; ?>
            
            <?php if ($result !== null): ?>
            <div class="result <?php echo ($result && isset($result['success']) && $result['success']) ? 'success' : 'error'; ?>">
                <strong>نتیجه API:</strong>
                <pre><?php echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE); ?></pre>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="card">
            <h2 style="margin-bottom:15px;"><i class="fas fa-list"></i> لیست eSIM های موجود</h2>
            <table style="width:100%;border-collapse:collapse;font-size:13px;">
                <tr style="background:#667eea;color:white;">
                    <th style="padding:10px;">سفارش</th>
                    <th style="padding:10px;">موبایل</th>
                    <th style="padding:10px;">esim_id</th>
                    <th style="padding:10px;">esim_tran_no</th>
                    <th style="padding:10px;">ICCID</th>
                </tr>
                <?php foreach ($esims as $esim): ?>
                <tr style="border-bottom:1px solid #eee;">
                    <td style="padding:10px;">#<?php echo $esim['id']; ?></td>
                    <td style="padding:10px;"><?php echo htmlspecialchars($esim['mobile']); ?></td>
                    <td style="padding:10px;direction:ltr;text-align:left;font-size:11px;">
                        <?php echo htmlspecialchars($esim['esim_id'] ?? '-'); ?>
                    </td>
                    <td style="padding:10px;direction:ltr;text-align:left;font-size:11px;background:<?php echo empty($esim['esim_tran_no']) ? '#fee' : '#efe'; ?>;">
                        <?php echo htmlspecialchars($esim['esim_tran_no'] ?? '-'); ?>
                    </td>
                    <td style="padding:10px;direction:ltr;text-align:left;font-size:11px;">
                        <?php echo htmlspecialchars(substr($esim['iccid'], 0, 20)); ?>...
                    </td>
                </tr>
                <?php endforeach; ?>
            </table>
            
            <div style="margin-top:20px;padding:15px;background:#fff3cd;border-radius:10px;color:#856404;">
                <i class="fas fa-exclamation-triangle"></i>
                <strong>توجه:</strong> اگر <code>esim_tran_no</code> خالی است، باید از صفحه 
                <a href="/sync-iccids.php">Sync ICCIDs</a> برای همگام‌سازی استفاده کنید.
            </div>
        </div>
    </div>
    
    <script>
    function updateSelectedInfo(select) {
        const option = select.options[select.selectedIndex];
        const infoDiv = document.getElementById('selectedInfo');
        
        if (option.value) {
            infoDiv.innerHTML = `
                <strong>موبایل کاربر:</strong> ${option.dataset.mobile || '-'} | 
                <strong>ICCID:</strong> ${option.dataset.iccid || '-'} |
                <strong>esimTranNo:</strong> ${option.value}
            `;
            infoDiv.style.display = 'block';
        } else {
            infoDiv.style.display = 'none';
        }
    }
    </script>
</body>
</html>

