<?php
// Debug file to check what happens when form is submitted
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';

echo "<h1>🐛 دیباگ فرم Checkout Topup</h1>";

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo "<p style='color: red;'>❌ شما لاگین نیستید!</p>";
    echo "<p><a href='/login.php'>لاگین کنید</a></p>";
    exit;
}

echo "<p style='color: green;'>✅ شما لاگین هستید (User ID: " . $_SESSION['user_id'] . ")</p>";

// Check POST data
echo "<h2>📤 اطلاعات POST:</h2>";
echo "<pre>";
echo "REQUEST_METHOD: " . $_SERVER['REQUEST_METHOD'] . "\n";
echo "\n_POST:\n";
print_r($_POST);
echo "\n_GET:\n";
print_r($_GET);
echo "</pre>";

// Check if form was submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<p style='color: green; font-size: 1.5rem;'>✅ فرم با POST ارسال شده!</p>";
    
    if (isset($_POST['confirm_topup'])) {
        echo "<p style='color: green;'>✅ فیلد confirm_topup موجود است!</p>";
    } else {
        echo "<p style='color: red;'>❌ فیلد confirm_topup موجود نیست!</p>";
        echo "<p>فیلدهای POST:</p>";
        echo "<pre>";
        print_r(array_keys($_POST));
        echo "</pre>";
    }
} else {
    echo "<p style='color: orange;'>⚠️ فرم هنوز ارسال نشده (GET request)</p>";
}

echo "<hr>";
echo "<h2>🧪 تست فرم:</h2>";
echo "<p>این یک فرم تست است. روی دکمه کلیک کنید:</p>";

?>

<form method="POST" action="" style="background: #f0f0f0; padding: 30px; border-radius: 10px; max-width: 500px;">
    <h3>فرم تست Topup</h3>
    
    <div style="margin: 20px 0;">
        <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
            <input type="checkbox" id="testCheckbox" name="confirm_checkbox" required style="width: 24px; height: 24px;">
            <span>مطمئن هستم که می‌خواهم تست کنم</span>
        </label>
    </div>
    
    <button type="submit" name="confirm_topup" id="testButton" disabled
            style="width: 100%; padding: 15px; background: #10b981; color: white; border: none; border-radius: 8px; font-size: 1.1rem; font-weight: 700; cursor: pointer;">
        تست پرداخت
    </button>
    
    <p style="margin-top: 15px; font-size: 0.9rem; color: #666;">
        ابتدا checkbox را تیک بزنید تا دکمه فعال شود
    </p>
</form>

<script>
document.addEventListener('DOMContentLoaded', function() {
    console.log('🚀 Debug form loaded');
    
    const checkbox = document.getElementById('testCheckbox');
    const button = document.getElementById('testButton');
    
    if (checkbox && button) {
        checkbox.addEventListener('change', function() {
            button.disabled = !this.checked;
            console.log('Checkbox changed:', this.checked);
            console.log('Button disabled:', button.disabled);
        });
    }
    
    const form = document.querySelector('form');
    if (form) {
        form.addEventListener('submit', function(e) {
            console.log('✅ Form is being submitted!');
            console.log('Form method:', this.method);
            console.log('Form action:', this.action || 'Same page');
            console.log('Checkbox checked:', checkbox.checked);
            
            // Don't prevent default - let it submit
        });
    }
});
</script>

<?php
echo "<hr>";
echo "<h2>📝 نتیجه:</h2>";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_topup'])) {
    echo "<div style='background: #d1fae5; border: 2px solid #10b981; padding: 20px; border-radius: 10px; margin: 20px 0;'>";
    echo "<h3 style='color: #065f46;'>🎉 موفقیت!</h3>";
    echo "<p>فرم به درستی ارسال شد و فیلد <code>confirm_topup</code> موجود است.</p>";
    echo "<p><strong>این یعنی کد PHP شما درست کار می‌کند!</strong></p>";
    echo "<p>حالا باید بررسی کنید چرا در <code>checkout-topup.php</code> به dashboard می‌رود.</p>";
    echo "</div>";
    
    echo "<h3>🔍 احتمالات:</h3>";
    echo "<ol>";
    echo "<li><strong>Session منقضی شده:</strong> بعد از submit، session از بین می‌رود</li>";
    echo "<li><strong>Redirect اشتباه:</strong> کد به جای proxy-payment.php به dashboard می‌رود</li>";
    echo "<li><strong>خطا در ساخت سفارش:</strong> سفارش ساخته نمی‌شود و به صفحه قبل برمی‌گردد</li>";
    echo "<li><strong>JavaScript مانع submit می‌شود:</strong> فرم اصلاً submit نمی‌شود</li>";
    echo "</ol>";
    
    echo "<h3>✅ مرحله بعد:</h3>";
    echo "<p>فایل <code>error_log</code> را چک کنید و به دنبال این پیام‌ها باشید:</p>";
    echo "<pre>";
    echo "🔵 Topup payment form submitted\n";
    echo "✅ Topup order created successfully\n";
    echo "🔄 Redirecting to: /proxy-payment.php?order_id=...\n";
    echo "</pre>";
    
} else {
    echo "<div style='background: #fef3c7; border: 2px solid #fbbf24; padding: 20px; border-radius: 10px; margin: 20px 0;'>";
    echo "<h3 style='color: #92400e;'>⚠️ فرم هنوز ارسال نشده</h3>";
    echo "<p>checkbox را تیک بزنید و روی \"تست پرداخت\" کلیک کنید.</p>";
    echo "</div>";
}

echo "<hr>";
echo "<h2>🔗 لینک‌های مفید:</h2>";
echo "<ul>";
echo "<li><a href='/checkout-topup.php?package=TEST&esim_id=1'>checkout-topup.php (تست)</a></li>";
echo "<li><a href='/test-checkout-topup.php'>test-checkout-topup.php</a></li>";
echo "<li><a href='/my-esims.php'>my-esims.php</a></li>";
echo "</ul>";
?>

<style>
body {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif;
    padding: 30px;
    background: #f9fafb;
}
pre {
    background: #1f2937;
    color: #f9fafb;
    padding: 15px;
    border-radius: 8px;
    overflow-x: auto;
}
code {
    background: #e5e7eb;
    padding: 2px 6px;
    border-radius: 4px;
    font-family: 'Courier New', monospace;
}
</style>

