<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';

echo "<h1>🔧 اضافه کردن فیلد esim_tran_no به دیتابیس</h1>";
echo "<style>body{font-family:Tahoma;padding:20px;direction:rtl;line-height:2;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;}</style>";

$conn = getDBConnection();

// Check if column already exists first
$checkSql = "SHOW COLUMNS FROM orders LIKE 'esim_tran_no'";
$result = $conn->query($checkSql);

if ($result && $result->num_rows > 0) {
    echo "<p class='success'>✅ فیلد esim_tran_no قبلاً وجود دارد</p>";
} else {
    // Add esim_tran_no column to orders table
    $sql = "ALTER TABLE orders ADD COLUMN esim_tran_no VARCHAR(100) NULL AFTER iccid";
    
    if ($conn->query($sql)) {
        echo "<p class='success'>✅ فیلد esim_tran_no با موفقیت اضافه شد</p>";
    } else {
        echo "<p class='error'>❌ خطا در اضافه کردن فیلد: " . $conn->error . "</p>";
    }
}

// Check and add order_type column
$checkSql2 = "SHOW COLUMNS FROM orders LIKE 'order_type'";
$result2 = $conn->query($checkSql2);

if ($result2 && $result2->num_rows > 0) {
    echo "<p class='success'>✅ فیلد order_type قبلاً وجود دارد</p>";
} else {
    $sql2 = "ALTER TABLE orders ADD COLUMN order_type VARCHAR(20) DEFAULT 'normal' AFTER status";
    
    if ($conn->query($sql2)) {
        echo "<p class='success'>✅ فیلد order_type با موفقیت اضافه شد</p>";
    } else {
        echo "<p class='error'>❌ خطا در اضافه کردن فیلد order_type: " . $conn->error . "</p>";
    }
}

// Check and add parent_order_id column
$checkSql3 = "SHOW COLUMNS FROM orders LIKE 'parent_order_id'";
$result3 = $conn->query($checkSql3);

if ($result3 && $result3->num_rows > 0) {
    echo "<p class='success'>✅ فیلد parent_order_id قبلاً وجود دارد</p>";
} else {
    $sql3 = "ALTER TABLE orders ADD COLUMN parent_order_id INT NULL AFTER order_type";
    
    if ($conn->query($sql3)) {
        echo "<p class='success'>✅ فیلد parent_order_id با موفقیت اضافه شد</p>";
    } else {
        echo "<p class='error'>❌ خطا در اضافه کردن فیلد parent_order_id: " . $conn->error . "</p>";
    }
}

// Show current table structure
echo "<hr>";
echo "<h2>📋 ساختار جدول orders:</h2>";
$result = $conn->query("DESCRIBE orders");

if ($result) {
    echo "<table border='1' cellpadding='10' style='border-collapse:collapse;width:100%;'>";
    echo "<tr style='background:#667eea;color:white;'><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    
    while ($row = $result->fetch_assoc()) {
        $highlight = ($row['Field'] == 'esim_tran_no') ? "style='background:#d1fae5;font-weight:bold;'" : "";
        echo "<tr $highlight>";
        echo "<td>" . $row['Field'] . "</td>";
        echo "<td>" . $row['Type'] . "</td>";
        echo "<td>" . $row['Null'] . "</td>";
        echo "<td>" . $row['Key'] . "</td>";
        echo "<td>" . ($row['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
}

$conn->close();

echo "<hr>";
echo "<p><a href='/test-api-topup.php'>تست API Topup</a></p>";
?>

