<?php
/**
 * Create auth_tokens table for token-based authentication
 * Run this file once to create the table
 */

require_once __DIR__ . '/config/database.php';

$conn = getDBConnection();

// Create auth_tokens table
$sql = "CREATE TABLE IF NOT EXISTS auth_tokens (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    token VARCHAR(64) NOT NULL UNIQUE,
    expires_at DATETIME NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_token (token),
    INDEX idx_user_id (user_id),
    INDEX idx_expires_at (expires_at),
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";

if ($conn->query($sql) === TRUE) {
    echo "✅ جدول auth_tokens با موفقیت ایجاد شد<br>";
} else {
    echo "❌ خطا در ایجاد جدول: " . $conn->error . "<br>";
}

$conn->close();

echo "<br><strong>✅ تمام! حالا می‌توانید این فایل را حذف کنید.</strong>";
?>

