<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../api/esim-api.php';

requireAdmin();

$pageTitle = 'مدیریت eSIM ها';
$success = '';
$error = '';

// Handle send SMS request
if (isset($_POST['send_sms'])) {
    $orderId = $_POST['order_id'] ?? 0;
    $esimId = $_POST['esim_id'] ?? '';
    $message = $_POST['message'] ?? '';
    
    if ($orderId && $esimId && $message) {
        try {
            $api = new eSIMAPI();
            $result = $api->sendSMS($esimId, $message);
            
            if ($result && isset($result['success']) && $result['success'] === true) {
                $success = 'پیامک با موفقیت ارسال شد';
            } else {
                $errorMsg = $result['errorMsg'] ?? 'خطای ناشناخته';
                $error = 'خطا در ارسال پیامک: ' . $errorMsg;
            }
        } catch (Exception $e) {
            $error = 'خطا: ' . $e->getMessage();
        }
    }
}

// Handle cancel request
if (isset($_POST['cancel_esim'])) {
    $orderId = $_POST['order_id'] ?? 0;
    $esimId = $_POST['esim_id'] ?? '';
    
    if ($orderId && $esimId) {
        try {
            $api = new eSIMAPI();
            $result = $api->cancelESIM($esimId);
            
            if ($result && isset($result['success']) && $result['success'] === true) {
                // Update order status
                $conn = getDBConnection();
                $stmt = $conn->prepare("UPDATE orders SET esim_status = 'cancelled' WHERE id = ?");
                $stmt->bind_param("i", $orderId);
                $stmt->execute();
                $stmt->close();
                $conn->close();
                
                $success = 'eSIM با موفقیت کنسل شد';
            } else {
                $errorMsg = $result['errorMsg'] ?? 'خطای ناشناخته';
                $error = 'خطا در کنسل کردن: ' . $errorMsg;
            }
        } catch (Exception $e) {
            $error = 'خطا: ' . $e->getMessage();
        }
    }
}

// Get all orders with eSIM
$conn = getDBConnection();
$query = "SELECT o.*, u.mobile, u.email 
          FROM orders o 
          LEFT JOIN users u ON o.user_id = u.id 
          WHERE o.status = 'paid' AND o.iccid IS NOT NULL AND o.iccid != ''
          ORDER BY o.created_at DESC 
          LIMIT 100";
$result = $conn->query($query);
$esims = [];
while ($row = $result->fetch_assoc()) {
    $esims[] = $row;
}
$conn->close();

include __DIR__ . '/../includes/header.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');

body, h1, h2, h3, h4, h5, h6, p, span, div, a, button, input, textarea, select, label, td, th {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
}

.fas, .far, .fab, .fa {
    font-family: "Font Awesome 6 Free", "Font Awesome 6 Brands" !important;
}


/* Same styles as orders.php */
.admin-container {
    display: flex;
    min-height: calc(100vh - 100px);
    gap: 0;
}

.admin-sidebar {
    width: 250px;
    background: white;
    box-shadow: 2px 0 10px rgba(0,0,0,0.1);
}

.sidebar-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 20px;
    text-align: center;
}

.sidebar-header i {
    font-size: 32px;
    margin-bottom: 10px;
}

.sidebar-header h3 {
    margin: 0;
    font-size: 18px;
}

.sidebar-menu {
    padding: 20px 0;
}

.sidebar-menu a {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 15px 20px;
    color: #666;
    text-decoration: none;
    transition: all 0.3s;
}

.sidebar-menu a:hover {
    background: #f5f5f5;
    color: #667eea;
}

.sidebar-menu a.active {
    background: #667eea;
    color: white;
    border-right: 4px solid #764ba2;
}

.sidebar-menu a i {
    width: 20px;
}

.admin-content {
    flex: 1;
    padding: 30px;
    background: #f5f7fa;
}

.page-header {
    margin-bottom: 30px;
}

.page-header h1 {
    color: #333;
    font-size: 28px;
}

.section {
    background: white;
    border-radius: 12px;
    padding: 25px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.table-responsive {
    overflow-x: auto;
}

.data-table {
    width: 100%;
    border-collapse: collapse;
}

.data-table thead {
    background: #f8f9fa;
}

.data-table th {
    padding: 15px;
    text-align: right;
    font-weight: 600;
    color: #666;
    border-bottom: 2px solid #e0e0e0;
}

.data-table td {
    padding: 15px;
    text-align: right;
    border-bottom: 1px solid #f0f0f0;
}

.data-table tr:hover {
    background: #f8f9fa;
}

.badge {
    display: inline-block;
    padding: 5px 12px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
}

.badge-success {
    background: #d4edda;
    color: #155724;
}

.badge-warning {
    background: #fff3cd;
    color: #856404;
}

.badge-error {
    background: #f8d7da;
    color: #721c24;
}

.btn-action {
    display: inline-block;
    padding: 6px 12px;
    background: #667eea;
    color: white;
    text-decoration: none;
    border-radius: 5px;
    transition: background 0.3s;
    border: none;
    cursor: pointer;
    font-size: 13px;
    margin: 0 2px;
}

.btn-action:hover {
    background: #5568d3;
}

.btn-action.btn-danger {
    background: #dc3545;
}

.btn-action.btn-danger:hover {
    background: #c82333;
}

.alert {
    padding: 15px;
    border-radius: 8px;
    margin-bottom: 20px;
}

.alert-success {
    background: #d4edda;
    border: 1px solid #c3e6cb;
    color: #155724;
}

.alert-error {
    background: #f8d7da;
    border: 1px solid #f5c6cb;
    color: #721c24;
}

.qr-preview {
    max-width: 100px;
    cursor: pointer;
}

.modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.5);
}

.modal-content {
    background: white;
    margin: 5% auto;
    padding: 30px;
    border-radius: 15px;
    max-width: 500px;
    text-align: center;
}

.modal-content img {
    max-width: 300px;
}

.modal-close {
    float: left;
    font-size: 28px;
    font-weight: bold;
    cursor: pointer;
    color: #999;
}

.modal-close:hover {
    color: #333;
}

@media (max-width: 768px) {
    .admin-container {
        flex-direction: column;
    }
    
    .admin-sidebar {
        width: 100%;
    }
}
</style>

<div class="admin-container">
    <div class="admin-sidebar">
        <div class="sidebar-header">
            <i class="fas fa-shield-alt"></i>
            <h3>پنل مدیریت</h3>
        </div>
        <nav class="sidebar-menu">
            <a href="/admin/">
                <i class="fas fa-home"></i>
                داشبورد
            </a>
            <a href="/admin/users.php">
                <i class="fas fa-users"></i>
                کاربران
            </a>
            <a href="/admin/orders.php">
                <i class="fas fa-shopping-cart"></i>
                سفارش‌ها
            </a>
            <a href="/admin/esims.php" class="active">
                <i class="fas fa-sim-card"></i>
                eSIM ها
            </a>
            <a href="/admin/settings.php">
                <i class="fas fa-cog"></i>
                تنظیمات
            </a>
            <a href="/">
                <i class="fas fa-arrow-left"></i>
                بازگشت به سایت
            </a>
        </nav>
    </div>

    <div class="admin-content">
        <div class="page-header">
            <h1><i class="fas fa-sim-card"></i> مدیریت eSIM ها</h1>
            <div style="margin-top: 15px;">
                <a href="/admin/cancel-esim-manual.php" class="btn-action">
                    <i class="fas fa-times-circle"></i>
                    کنسل دستی eSIM
                </a>
                <a href="/admin/test-sms.php" class="btn-action" style="background:#28a745;">
                    <i class="fas fa-sms"></i>
                    تست SMS
                </a>
                <a href="/admin/usage-alerts.php" class="btn-action" style="background:#f59e0b;">
                    <i class="fas fa-bell"></i>
                    اعلان‌های مصرف
                </a>
                <a href="/admin/auto-check-status.php" class="btn-action" style="background:#8b5cf6;">
                    <i class="fas fa-robot"></i>
                    سیستم خودکار
                </a>
            </div>
        </div>

        <?php if ($success): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <?php echo $success; ?>
        </div>
        <?php endif; ?>

        <?php if ($error): ?>
        <div class="alert alert-error">
            <i class="fas fa-exclamation-circle"></i>
            <?php echo $error; ?>
        </div>
        <?php endif; ?>

        <div class="section">
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>سفارش</th>
                            <th>کاربر</th>
                            <th>بسته</th>
                            <th>ICCID</th>
                            <th>QR Code</th>
                            <th>وضعیت</th>
                            <th>تاریخ</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($esims)): ?>
                            <tr>
                                <td colspan="8" style="text-align: center; padding: 30px; color: #999;">
                                    هیچ eSIM فعالی یافت نشد
                                </td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($esims as $esim): ?>
                            <tr>
                                <td><strong>#<?php echo $esim['id']; ?></strong></td>
                                <td><?php echo htmlspecialchars($esim['mobile']); ?></td>
                                <td><?php echo htmlspecialchars($esim['package_name']); ?></td>
                                <td>
                                    <small><?php echo htmlspecialchars(substr($esim['iccid'], 0, 15)); ?>...</small>
                                </td>
                                <td>
                                    <?php if ($esim['qr_code']): ?>
                                        <img src="<?php echo htmlspecialchars($esim['qr_code']); ?>" 
                                             class="qr-preview" 
                                             onclick="showQR('<?php echo htmlspecialchars($esim['qr_code']); ?>')"
                                             alt="QR">
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php 
                                    $status = $esim['esim_status'] ?? 'active';
                                    if ($status == 'cancelled'): 
                                    ?>
                                        <span class="badge badge-error">کنسل شده</span>
                                    <?php else: ?>
                                        <span class="badge badge-success">فعال</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo date('Y/m/d', strtotime($esim['created_at'])); ?></td>
                                <td>
                                    <a href="/debug-esim-creation.php?order=<?php echo $esim['id']; ?>" 
                                       class="btn-action" 
                                       title="جزئیات">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    
                                    <?php 
                                    // Check if eSIM can be cancelled - esim_tran_no is the esimTranNo from API
                                    $esimTranNo = $esim['esim_tran_no'] ?? $esim['esim_id'] ?? '';
                                    $canCancel = ($status != 'cancelled') && !empty($esimTranNo);
                                    ?>
                                    
                                    <?php if ($canCancel): ?>
                                    <!-- SMS Button -->
                                    <button class="btn-action" 
                                            onclick="showSMSModal(<?php echo $esim['id']; ?>, '<?php echo htmlspecialchars($esimTranNo); ?>')" 
                                            title="ارسال SMS">
                                        <i class="fas fa-sms"></i>
                                    </button>
                                    
                                    <!-- Cancel Button -->
                                    <form method="POST" style="display: inline;" 
                                          onsubmit="return confirm('آیا مطمئن هستید که می‌خواهید این eSIM را کنسل کنید؟');">
                                        <input type="hidden" name="order_id" value="<?php echo $esim['id']; ?>">
                                        <input type="hidden" name="esim_id" value="<?php echo htmlspecialchars($esimTranNo); ?>">
                                        <button type="submit" name="cancel_esim" class="btn-action btn-danger" title="کنسل">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </form>
                                    <?php elseif ($status != 'cancelled'): ?>
                                    <!-- If no identifier, show message -->
                                    <span class="badge badge-warning" title="eSIM ID موجود نیست">
                                        <i class="fas fa-exclamation-triangle"></i>
                                        بدون شناسه
                                    </span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- QR Code Modal -->
<div id="qrModal" class="modal">
    <div class="modal-content">
        <span class="modal-close" onclick="closeQR()">&times;</span>
        <h2>QR Code</h2>
        <img id="qrImage" src="" alt="QR Code">
    </div>
</div>

<!-- SMS Modal -->
<div id="smsModal" class="modal">
    <div class="modal-content">
        <span class="modal-close" onclick="closeSMS()">&times;</span>
        <h2><i class="fas fa-sms"></i> ارسال پیامک</h2>
        <form method="POST" style="margin-top: 20px;">
            <input type="hidden" name="order_id" id="smsOrderId">
            <input type="hidden" name="esim_id" id="smsEsimId">
            <div style="margin-bottom: 15px;">
                <label style="display: block; margin-bottom: 8px; font-weight: 600;">متن پیامک:</label>
                <textarea name="message" 
                          rows="4" 
                          style="width: 100%; padding: 12px; border: 2px solid #e0e0e0; border-radius: 8px; font-size: 14px;"
                          placeholder="متن پیامک خود را وارد کنید..."
                          required></textarea>
                <small style="color: #666;">حداکثر 160 کاراکتر</small>
            </div>
            <button type="submit" name="send_sms" class="btn-action" style="width: 100%; padding: 12px;">
                <i class="fas fa-paper-plane"></i>
                ارسال پیامک
            </button>
        </form>
    </div>
</div>

<script>
function showQR(url) {
    document.getElementById('qrImage').src = url;
    document.getElementById('qrModal').style.display = 'block';
}

function closeQR() {
    document.getElementById('qrModal').style.display = 'none';
}

function showSMSModal(orderId, esimId) {
    document.getElementById('smsOrderId').value = orderId;
    document.getElementById('smsEsimId').value = esimId;
    document.getElementById('smsModal').style.display = 'block';
}

function closeSMS() {
    document.getElementById('smsModal').style.display = 'none';
}

// Close modal when clicking outside
window.onclick = function(event) {
    const qrModal = document.getElementById('qrModal');
    const smsModal = document.getElementById('smsModal');
    if (event.target == qrModal) {
        qrModal.style.display = 'none';
    }
    if (event.target == smsModal) {
        smsModal.style.display = 'none';
    }
}
</script>

<?php include __DIR__ . '/../includes/footer.php'; ?>

