<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Add Missing Functions</h1>";

$functionsPath = __DIR__ . '/includes/functions.php';

if (!file_exists($functionsPath)) {
    echo "<p style='color: red;'>❌ functions.php not found!</p>";
    exit;
}

// Read current content
$currentContent = file_get_contents($functionsPath);

// Check if functions already exist
if (strpos($currentContent, 'function updateOrderStatus') !== false) {
    echo "<p style='color: orange;'>⚠️ updateOrderStatus already exists!</p>";
} else {
    echo "<p style='color: green;'>✅ updateOrderStatus will be added</p>";
}

if (strpos($currentContent, 'function updateOrderWithESIM') !== false) {
    echo "<p style='color: orange;'>⚠️ updateOrderWithESIM already exists!</p>";
} else {
    echo "<p style='color: green;'>✅ updateOrderWithESIM will be added</p>";
}

// New functions to add
$newFunctions = <<<'PHP'

// Update order status
function updateOrderStatus($orderId, $status, $paymentData = []) {
    $conn = getDBConnection();
    
    if (isset($paymentData['authority'])) {
        $stmt = $conn->prepare("UPDATE orders SET status = ?, payment_authority = ? WHERE id = ?");
        $stmt->bind_param("ssi", $status, $paymentData['authority'], $orderId);
    } elseif (isset($paymentData['ref_id'])) {
        $stmt = $conn->prepare("UPDATE orders SET status = ?, payment_ref_id = ?, paid_at = NOW() WHERE id = ?");
        $stmt->bind_param("ssi", $status, $paymentData['ref_id'], $orderId);
    } else {
        $stmt = $conn->prepare("UPDATE orders SET status = ? WHERE id = ?");
        $stmt->bind_param("si", $status, $orderId);
    }
    
    $result = $stmt->execute();
    $stmt->close();
    $conn->close();
    return $result;
}

// Update order with eSIM data
function updateOrderWithESIM($orderId, $esimData) {
    $conn = getDBConnection();
    
    $stmt = $conn->prepare("UPDATE orders SET esim_id = ?, iccid = ?, qr_code = ?, activation_code = ? WHERE id = ?");
    $stmt->bind_param("ssssi",
        $esimData['esim_id'],
        $esimData['iccid'],
        $esimData['qr_code'],
        $esimData['activation_code'],
        $orderId
    );
    
    $result = $stmt->execute();
    $stmt->close();
    $conn->close();
    return $result;
}

PHP;

if (isset($_POST['add_functions'])) {
    // Backup original file
    $backupPath = $functionsPath . '.backup.' . date('YmdHis');
    if (copy($functionsPath, $backupPath)) {
        echo "<p style='color: green;'>✅ Backup created: " . basename($backupPath) . "</p>";
    }
    
    // Add new functions
    $newContent = $currentContent . "\n" . $newFunctions;
    
    if (file_put_contents($functionsPath, $newContent)) {
        echo "<p style='color: green; font-size: 20px;'>✅ Functions added successfully!</p>";
        echo "<p><a href='check-functions.php' style='background: #28a745; color: white; padding: 15px 30px; text-decoration: none; border-radius: 8px; display: inline-block;'>Check Functions Again</a></p>";
    } else {
        echo "<p style='color: red;'>❌ Failed to write file!</p>";
    }
} else {
    echo "<h2>Preview of Functions to Add:</h2>";
    echo "<pre>" . htmlspecialchars($newFunctions) . "</pre>";
    
    echo "<form method='POST'>";
    echo "<button type='submit' name='add_functions' style='background: #667eea; color: white; padding: 15px 30px; border: none; border-radius: 8px; font-size: 16px; cursor: pointer;'>Add These Functions to functions.php</button>";
    echo "</form>";
    
    echo "<p style='color: orange; margin-top: 20px;'><strong>Note:</strong> A backup will be created before modifying the file.</p>";
}

?>

<style>
body {
    font-family: Tahoma, Arial, sans-serif;
    padding: 20px;
    direction: rtl;
    max-width: 1200px;
    margin: 0 auto;
}
h1, h2 {
    color: #333;
    border-bottom: 2px solid #667eea;
    padding-bottom: 10px;
}
pre {
    background: #f5f5f5;
    padding: 15px;
    border-radius: 5px;
    overflow-x: auto;
    direction: ltr;
    text-align: left;
}
</style>

