# 🔐 رفع مشکل احراز هویت با Token

## 📋 مشکل

مشکل اصلی این بود که:
1. ✅ در لاگین، Session ست می‌شد
2. ❌ ولی Token ساخته نمی‌شد
3. ❌ در نتیجه صفحاتی که نیاز به لاگین داشتند، نمی‌توانستند Token را از localStorage بخوانند
4. ❌ کاربر مجبور می‌شد دوباره لاگین کند

## ✅ راه‌حل

### 1. ایجاد تابع `createAuthToken()` در `includes/functions.php`

تابعی اضافه شد که برای کاربر یک Token تصادفی 64 کاراکتری ایجاد می‌کند و در جدول `auth_tokens` ذخیره می‌کند.

```php
function createAuthToken($userId) {
    $token = bin2hex(random_bytes(32));
    $expiresAt = date('Y-m-d H:i:s', strtotime('+30 days'));
    
    // حذف توکن‌های قدیمی و ایجاد توکن جدید
    // ...
    
    return $token;
}
```

### 2. آپدیت تابع `loginWithOTP()` در `includes/functions.php`

تابع لاگین حالا بعد از ست کردن Session، یک Token هم می‌سازد و برمی‌گرداند:

```php
function loginWithOTP($mobile, $code) {
    // ... بررسی OTP و پیدا کردن کاربر ...
    
    // ایجاد session
    $_SESSION['user_id'] = $user['id'];
    // ...
    
    // ✨ ایجاد توکن احراز هویت
    $token = createAuthToken($user['id']);
    
    return [
        'success' => true,
        'message' => 'ورود موفقیت‌آمیز',
        'token' => $token,  // ✅ برگرداندن Token
        'user' => [...]
    ];
}
```

### 3. آپدیت تابع `registerWithOTP()` در `includes/functions.php`

مشابه تابع لاگین، تابع ثبت‌نام هم حالا Token می‌سازد.

### 4. آپدیت `login.php`

صفحه لاگین حالا Token دریافتی را در JavaScript می‌گیرد و در localStorage ذخیره می‌کند:

```javascript
// بعد از لاگین موفق از API
if (data.token) {
    localStorage.setItem('auth_token', data.token);
    localStorage.setItem('user_data', JSON.stringify(data.user));
    console.log('✅ لاگین موفق - Token ذخیره شد');
}
```

### 5. اضافه کردن `auth-token.js` به `includes/header.php`

این اسکریپت به طور خودکار در تمام صفحات لود می‌شود و:
- ✅ Token را از localStorage می‌خواند
- ✅ به تمام لینک‌های داخلی اضافه می‌کند (`?token=...`)
- ✅ به تمام فرم‌ها به صورت hidden input اضافه می‌کند
- ✅ به تمام درخواست‌های fetch به صورت Authorization header اضافه می‌کند

## 🔄 جریان کار

### لاگین:
1. کاربر در `/login.php` شماره موبایل را وارد می‌کند
2. کد OTP از طریق `/api/send-otp.php` ارسال می‌شود
3. کاربر کد را وارد می‌کند
4. ✅ بعد از تایید از `/api/verify-otp.php`:
   - Session ست می‌شود
   - **Token ساخته می‌شود**
   - Token در localStorage ذخیره می‌شود (خط 714-716 در login.php)
   - کاربر به داشبورد منتقل می‌شود

### دسترسی به صفحات محافظت‌شده:
1. صفحه تابع `isLoggedIn()` را فراخوانی می‌کند
2. تابع ابتدا Session را چک می‌کند
3. ✅ اگر Session نبود، Token را چک می‌کند:
   - از Authorization header
   - یا از `$_GET['token']`
   - یا از `$_POST['token']`
4. اگر Token معتبر بود، Session را دوباره ست می‌کند
5. کاربر دسترسی پیدا می‌کند

## 🧪 تست

### تست لاگین:
1. برو به `/login.php`
2. شماره موبایل وارد کن و کد OTP دریافت کن
3. کد را وارد کن و لاگین کن
4. Console مرورگر (F12 → Console) رو باز کن
5. باید پیام `✅ لاگین موفق - Token ذخیره شد` رو ببینی

### تست Token:
برای بررسی دقیق سیستم Token، به این آدرس برو:
```
/test-token-auth.php
```

این صفحه نشان می‌دهد:
- ✅ وضعیت لاگین (Session)
- ✅ اطلاعات کاربر
- ✅ وجود Token در localStorage
- ✅ نحوه ارسال Token در URL و Form
- ✅ Headers و Parameters

## 📝 نکات مهم

1. **امنیت**: Token ها 30 روز اعتبار دارند و در دیتابیس ذخیره می‌شوند
2. **Session**: Session به عنوان اولین اولویت چک می‌شود، Token فقط برای fallback است
3. **localStorage**: فقط در مرورگر کار می‌کند (WebView موبایل هم پشتیبانی می‌کند)
4. **خروج**: وقتی کاربر logout می‌کند، باید Token هم از localStorage پاک شود

## 🔧 تغییرات فایل‌ها

### فایل‌های تغییر یافته:
- ✅ `includes/functions.php` - اضافه شدن `createAuthToken()` و آپدیت `loginWithOTP()` و `registerWithOTP()`
- ✅ `login.php` - اضافه شدن console.log برای debug کردن Token
- ✅ `includes/header.php` - اضافه شدن `<script src="/assets/js/auth-token.js"></script>`

### فایل‌های جدید:
- ✅ `test-token-auth.php` - صفحه تست سیستم احراز هویت

### فایل‌های موجود که قبلاً آماده بودند:
- ✅ `login.php` - صفحه لاگین با OTP که قبلاً Token رو ذخیره می‌کرد
- ✅ `api/verify-otp.php` - تایید OTP و ساخت Token
- ✅ `api/register-user.php` - ثبت‌نام کاربر و ساخت Token
- ✅ `assets/js/auth-token.js` - اسکریپت خودکار اضافه کردن Token
- ✅ `config/config.php` - تابع `isLoggedIn()` که هم Session و هم Token را چک می‌کند
- ✅ `create-auth-tokens-table.php` - ایجاد جدول `auth_tokens` (باید یکبار اجرا شود)

## 🎉 نتیجه

حالا سیستم احراز هویت به درستی کار می‌کند:
- ✅ در لاگین، Token ساخته می‌شود
- ✅ در صفحات محافظت‌شده، Token خوانده می‌شود
- ✅ کاربر نیازی به لاگین مجدد ندارد
- ✅ در WebView موبایل هم به درستی کار می‌کند

---

**تاریخ ایجاد**: 2025-01-13  
**نسخه**: 1.0

