# 🚀 نسخه جدید eSIM مَتینا کارت

## این نسخه جدیدترین نسخه پروژه است

این فولدر شامل جدیدترین و کامل‌ترین نسخه کد پروژه eSIM است که از بین تمام فولدرهای موجود انتخاب شده.

---

## ✅ ویژگی‌های این نسخه

### 🔐 سیستم احراز هویت
- ورود با OTP (کد یکبار مصرف)
- Token Authentication 
- ذخیره توکن در Cookie و localStorage
- Auth Sync خودکار برای WebView

### 📱 طراحی ریسپانسیو
- Bottom Navigation برای موبایل
- منوی همبرگری برای صفحات کوچک
- طراحی بهینه برای همه سایزها

### 💳 سیستم پرداخت
- اتصال به زرین‌پال
- Proxy Payment برای سرورهای خارج
- Callback handling کامل

### 🌐 سیستم eSIM
- API کامل eSIM Access
- خرید بسته جدید
- شارژ مجدد (Topup)
- مشاهده جزئیات eSIM

---

## 📁 ساختار فایل‌ها

```
newversion/
├── index.php                 # صفحه اصلی - لیست کشورها
├── country.php              # صفحه بسته‌های هر کشور
├── checkout.php             # صفحه تکمیل خرید
├── login.php                # صفحه ورود با OTP
├── register.php             # صفحه ثبت نام
├── dashboard.php            # داشبورد کاربر
├── my-esims.php             # لیست eSIM های کاربر
├── esim-details.php         # جزئیات eSIM
├── buy-more-data.php        # شارژ مجدد eSIM
├── 
├── admin/                   # پنل مدیریت
│   ├── index.php           # داشبورد ادمین
│   ├── orders.php          # مدیریت سفارشات
│   ├── users.php           # مدیریت کاربران
│   ├── esims.php           # مدیریت eSIM ها
│   └── settings.php        # تنظیمات
├── 
├── api/                     # API ها
│   ├── esim-api.php        # کلاس اصلی eSIM API
│   ├── sms-api.php         # سرویس پیامک
│   ├── send-otp.php        # ارسال کد OTP
│   ├── verify-otp.php      # بررسی کد OTP
│   └── register-user.php   # ثبت نام کاربر
├── 
├── config/                  # تنظیمات
│   ├── config.php          # تنظیمات اصلی
│   └── database.php        # اتصال دیتابیس
├── 
├── includes/                # فایل‌های مشترک
│   ├── header.php          # هدر سایت
│   ├── footer.php          # فوتر سایت
│   ├── functions.php       # توابع کاربردی
│   └── session-config.php  # تنظیمات Session
├── 
├── assets/                  # فایل‌های استاتیک
│   ├── css/
│   │   ├── style.css       # استایل اصلی
│   │   ├── colors.css      # رنگ‌ها
│   │   └── vazirmatn-font.css  # فونت وزیر
│   └── js/
│       ├── script.js       # اسکریپت اصلی
│       └── auth-token.js   # مدیریت توکن
├── 
├── user/                    # صفحات کاربر
│   ├── dashboard.php
│   ├── my-esims.php
│   ├── esim-details.php
│   └── profile.php
├── 
├── proxy-payment.php        # پرداخت پروکسی
├── proxy-callback.php       # کال‌بک پرداخت
├── proxy-handler.php        # هندلر پروکسی
├── auth-sync.php            # همگام‌سازی توکن
└── install.php              # نصب اولیه
```

---

## 🔧 تنظیمات مورد نیاز

### 1. دیتابیس
فایل `config/database.php` را ویرایش کنید.

### 2. API eSIM Access
فایل `config/config.php`:
- `ESIM_ACCESS_CODE`
- `ESIM_SECURITY_KEY`

### 3. سرویس پیامک
فایل `api/sms-api.php`:
- IPPanel API Key

---

## 📦 نصب

1. فایل‌ها را روی سرور آپلود کنید
2. `install.php` را اجرا کنید برای ساخت جداول
3. `install-otp-db.php` را اجرا کنید برای جدول OTP
4. تنظیمات را در پنل ادمین وارد کنید

---

## 🔄 فایل‌های اضافی (Setup)

این فایل‌ها فقط یکبار برای setup استفاده می‌شن:
- `add-missing-columns.php` - اضافه کردن ستون‌های جدید
- `add-esim-tran-no.php` - اضافه کردن فیلد esimTranNo
- `add-topup-fields.php` - فیلدهای topup
- `create-auth-tokens-table.php` - جدول توکن‌ها

---

## 📝 نکات مهم

1. **این نسخه از فولدر `esimapp/esim.matinacard.com 2/` استخراج شده**
2. فایل‌های تست و debug حذف شده‌اند
3. این نسخه شامل Token Auth و Bottom Navigation است
4. برای WebView اپلیکیشن موبایل بهینه شده

---

**آخرین بروزرسانی:** دسامبر 2024


