# 🎯 راه‌حل نهایی و کامل احراز هویت

## 📋 خلاصه مشکل و راه‌حل

### مشکل:
کاربر بعد از لاگین، وقتی به صفحات دیگه میرفت، دوباره درخواست لاگین می‌شد.

### ریشه مشکل:
1. Token در localStorage ذخیره می‌شد ✅
2. ولی PHP نمی‌تونست localStorage رو بخونه ❌
3. Session در موبایل/WebView حفظ نمی‌شد ❌

### راه‌حل نهایی: ترکیب Cookie + localStorage + Session

```
localStorage (Client) ↔️ Cookie (Client/Server) ↔️ Session (Server)
```

## 🔧 معماری راه‌حل

### لایه 1: JavaScript در Client (اولین چک)
```javascript
// در <head> قبل از هر چیز اجرا میشه
1. Token رو از localStorage می‌خونه
2. اگر Token هست:
   - Cookie رو ست می‌کنه (اگر نیست)
   - ادامه میده ✅
3. اگر Token نیست و صفحه محافظت‌شده‌ست:
   - به /login.php redirect می‌کنه ❌
```

### لایه 2: Cookie در هر Request
```php
// PHP خودکار Cookie رو می‌خونه
1. هر Request → Cookie ارسال میشه
2. PHP از Cookie Token رو می‌خونه
3. Session رو ست می‌کنه
4. کاربر وارد میشه ✅
```

### لایه 3: Session برای درخواست‌های بعدی
```php
// بعد از ست شدن Session، دیگه نیازی به Token نیست
1. Session ست شده؟ ✅
2. مستقیم ادامه میده
```

## 📁 تغییرات فایل‌ها

### 1. `includes/header.php` - چک خودکار Token

```javascript
<script>
    const requireAuth = <?php echo $requireAuth ? 'true' : 'false'; ?>;
    const token = localStorage.getItem('auth_token');
    
    if (token) {
        // ست کردن Cookie از localStorage
        if (!document.cookie.includes('auth_token=')) {
            document.cookie = 'auth_token=' + token + '; path=/; max-age=' + (30*24*60*60);
        }
    } else if (requireAuth) {
        // Token نیست و صفحه محافظت‌شده‌ست
        if (!window.location.pathname.includes('/login')) {
            window.location.href = '/login.php';
        }
    }
</script>
```

### 2. `config/config.php` - خواندن از Cookie

```php
function isLoggedIn() {
    // 1. چک Session
    if (isset($_SESSION['user_id'])) {
        return true;
    }
    
    // 2. چک Cookie
    if (isset($_COOKIE['auth_token'])) {
        $token = $_COOKIE['auth_token'];
        $user = getUserByToken($token);
        if ($user) {
            // ست کردن Session
            $_SESSION['user_id'] = $user['id'];
            // ...
            return true;
        }
    }
    
    return false;
}
```

### 3. `login.php` - ذخیره در localStorage و Cookie

```javascript
if (data.token) {
    // localStorage
    localStorage.setItem('auth_token', data.token);
    
    // Cookie
    document.cookie = 'auth_token=' + data.token + '; path=/; max-age=' + (30*24*60*60);
    
    console.log('✅ Token ذخیره شد');
}
```

### 4. `logout.php` - پاک کردن همه

```php
// پاک کردن Session
session_destroy();

// پاک کردن Cookie
setcookie('auth_token', '', time() - 3600, '/');
```

```javascript
// پاک کردن localStorage
localStorage.removeItem('auth_token');
```

## 🔄 جریان کار کامل

### سناریو 1: لاگین اولیه
```
1. کاربر به /login.php میره
2. شماره موبایل و OTP وارد می‌کنه
3. API Token می‌سازه
4. JavaScript:
   - Token در localStorage ذخیره میشه ✅
   - Token در Cookie ذخیره میشه ✅
5. Redirect به /dashboard.php
6. PHP از Cookie Token رو می‌خونه ✅
7. Session ست میشه ✅
8. کاربر وارد میشه! 🎉
```

### سناریو 2: کلیک روی لینک
```
1. کاربر روی "eSIM های من" کلیک می‌کنه
2. صفحه شروع به لود میشه
3. JavaScript در <head> اجرا میشه:
   - Token رو از localStorage می‌خونه ✅
   - Cookie رو چک می‌کنه
   - اگر Cookie نبود، ست می‌کنه ✅
4. Request به سرور میره
5. PHP از Cookie Token رو می‌خونه ✅
6. Session ست میشه ✅
7. کاربر وارد میشه! 🎉
```

### سناریو 3: بسته و باز کردن مرورگر
```
1. کاربر مرورگر رو می‌بنده
2. بعد از چند ساعت باز می‌کنه
3. به /dashboard.php میره
4. JavaScript:
   - Token رو از localStorage می‌خونه ✅
   - Cookie ست می‌کنه ✅
5. PHP از Cookie Token رو می‌خونه ✅
6. Session ست میشه ✅
7. کاربر وارد میشه! 🎉
```

### سناریو 4: Token نداره
```
1. کاربر به /my-esims.php میره
2. JavaScript در <head> اجرا میشه:
   - Token رو از localStorage می‌خونه
   - Token موجود نیست! ❌
   - requireAuth = true
   - Redirect به /login.php ⚠️
3. کاربر به صفحه لاگین میره
```

## ✅ چک لیست تست

### تست 1: لاگین اولیه
- [ ] برو به /login.php
- [ ] لاگین کن
- [ ] Console رو چک کن: `✅ Token ذخیره شد`
- [ ] به /dashboard.php redirect میشه
- [ ] وارد میشه بدون خطا

### تست 2: کلیک روی لینک‌ها
- [ ] روی "eSIM های من" کلیک کن
- [ ] روی "داشبورد" کلیک کن
- [ ] هیچ جا درخواست لاگین نمی‌کنه

### تست 3: Refresh صفحه
- [ ] در /my-esims.php هستی
- [ ] F5 (Refresh) بزن
- [ ] نباید به لاگین بره

### تست 4: بسته و باز کردن مرورگر
- [ ] مرورگر رو ببند
- [ ] دوباره باز کن
- [ ] به /dashboard.php برو
- [ ] باید بدون لاگین وارد بشه

### تست 5: Token ندارد
- [ ] localStorage رو پاک کن: `localStorage.clear()`
- [ ] Cookie رو پاک کن
- [ ] به /my-esims.php برو
- [ ] باید به /login.php redirect بشه

### تست 6: خروج
- [ ] روی "خروج" کلیک کن
- [ ] به صفحه اصلی میره
- [ ] به /dashboard.php برو
- [ ] باید به /login.php redirect بشه

## 🐛 عیب‌یابی

### مشکل: هنوز درخواست لاگین می‌کند
✅ راه‌حل:
```javascript
// Console رو باز کن و چک کن:
localStorage.getItem('auth_token')  // باید Token رو نشون بده
document.cookie                      // باید auth_token رو نشون بده
```

### مشکل: بعد از Refresh لاگین می‌خواد
✅ راه‌حل:
```php
// چک کن Cookie ست شده:
print_r($_COOKIE);  // باید auth_token رو نشون بده
```

### مشکل: در Console خطای JavaScript
✅ راه‌حل:
- مطمئن شو /assets/js/auth-token.js آپلود شده
- Console رو چک کن برای خطای دقیق

## 📊 مقایسه روش‌ها

| روش | مزایا | معایب |
|-----|-------|--------|
| **Session فقط** | ساده | در موبایل حفظ نمیشه |
| **localStorage فقط** | حفظ میشه | PHP نمی‌تونه بخونه |
| **Token در URL** | همه جا کار می‌کنه | URL گند میشه |
| **Cookie + localStorage** ✅ | همه مزایا | - |

## 🎉 نتیجه نهایی

با این راه‌حل:
- ✅ Token در localStorage ذخیره میشه (برای ماندگاری)
- ✅ Token در Cookie ذخیره میشه (برای PHP)
- ✅ Session ست میشه (برای سرعت)
- ✅ JavaScript خودکار Token رو sync می‌کنه
- ✅ در همه مرورگرها و دستگاه‌ها کار می‌کنه
- ✅ تجربه کاربری عالی (بدون redirect‌های مکرر)

---

**نسخه**: 4.0 (نسخه نهایی و کامل)  
**تاریخ**: 2025-01-13

